package ch.parrado.android.groopy.base;

import java.util.ArrayList;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import ch.parrado.android.groopy.domaine.Offre;
import ch.parrado.android.groopy.domaine.Client;
import static ch.parrado.android.groopy.base.NomsBase.*;


/**
 * Emploi de la base de donnees SQLite - Gestion d'achats groupes
 *
 * Activite principale: affichage des offres
 *
 * @author Nicolas Parrado
 */
public class GestionAchatsDao {

    private static final int VERSION = 1;                      /* Version de la base de donnees */
    private static final String NOM_BASE = "AchatsGroupes.db"; /* Nom de la base de donnees */

    private GestionAchatsOpenHelper openHelper; /* Utilitaire d'aide a la gestion de la base de donnees */
    private SQLiteDatabase bdd;                 /* Reference � la base de donnees */

    /** Constructeur */
    public GestionAchatsDao (Context context) {
        openHelper = new GestionAchatsOpenHelper(context, NOM_BASE, null, VERSION);
    } // Constructeur

    /** Ouverture de la base en ecriture */
    public void open () {bdd = openHelper.getWritableDatabase();}

    /** Fermeture de la base */
    public void close () {bdd.close();}

    /** Retourne la liste complete des Offres par ordre des libelles */
    public ArrayList<Offre> getListeOffres () {
        ArrayList<Offre> lstOff = new ArrayList<Offre>();
        Cursor curOff = bdd.query(TBL_OFFRE, new String[] {COL_IDO, COL_LIBELLE, COL_PRIX, COL_MIN, COL_MAX}, null, null, null, null, COL_LIBELLE);
        if (!curOff.moveToFirst()){curOff.close(); return null;}
        while (curOff.moveToNext()) {
            int id = curOff.getInt(0);
            String libelle = curOff.getString(1);
            Double prix = curOff.getDouble(2);
            int minInscrits = curOff.getInt(3);
            int maxInscrits = curOff.getInt(4);
            int inscritsActuels = getNbInscrit(id);
            lstOff.add(new Offre(id, libelle, prix, minInscrits, maxInscrits, inscritsActuels));
        }//while
        curOff.close();
        //System.out.println("Nombre d'element dans le curseur        : " + curOff.getCount());
        //System.out.println("Nombre d'element dans la liste d'offres : " + lstOff.size());
        return lstOff;
    } // getListeOffres

    /** Retourne le nombre d'inscrit pour l'Offre avec l'id */
    private int getNbInscrit (int id) {
        Cursor curIns = bdd.query(TBL_ESTINSCRIT, new String[] {COL_ID_OFFRE, COL_ID_CLIENT}, COL_ID_OFFRE + " = " + id, null, null, null, null);
        try {return curIns.getCount();} finally {curIns.close();}
    } // getNbInscrit

    /** Retourne la liste des Clients inscrits a une Offre d'Id donne par ordre des noms */
    public ArrayList<Client> getListeClients (int idO) {
        ArrayList<Client> lstCli = new ArrayList<Client>();
        Cursor curIns = bdd.query(TBL_ESTINSCRIT, new String[] {COL_ID_OFFRE, COL_ID_CLIENT}, COL_ID_OFFRE + " = " + idO, null, null, null, null);
        while (curIns.moveToNext()) {
            Cursor curCli = bdd.query(TBL_CLIENT, new String[] {COL_IDC, COL_NOM, COL_PRENOM, COL_EMAIL}, COL_IDC + " = " + curIns.getInt(1) , null, null, null, COL_NOM);
            while (curCli.moveToNext()) {
                int id = curCli.getInt(0);
                String nom = curCli.getString(1);
                String prenom = curCli.getString(2);
                String eMail = curCli.getString(3);
                lstCli.add(new Client(id, nom, prenom, eMail));
            }
            curCli.close();
        }
        curIns.close();
        return lstCli;
    } // getListeClients
    
}//GestionAchatsDao
