package ch.parrado.android.groopy.base;

import static ch.parrado.android.groopy.base.NomsBase.*;
import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabase.CursorFactory;
import android.database.sqlite.SQLiteOpenHelper;

/**
 * Emploi de la base de donnees SQLite - Gestion d'achats groupes
 *
 * Aide a la creation / mise a jour de la base de donnees
 *
 */
public class GestionAchatsOpenHelper extends SQLiteOpenHelper {

    private static final String CREATE_OFFRE =
            "CREATE TABLE " + TBL_OFFRE + "(" +
                    COL_IDO     + " INTEGER PRIMARY KEY AUTOINCREMENT, " +
                    COL_LIBELLE + " TEXT NOT NULL, " +
                    COL_PRIX    + " REAL NOT NULL, " +
                    COL_MIN     + " INTEGER NOT NULL, " +
                    COL_MAX     + " INTEGER NOT NULL " +
                    ");";
    private static final String DROP_OFFRE = "DROP TABLE " + TBL_OFFRE + ";";

    private static final String CREATE_ESTINSCRIT =
            "CREATE TABLE " + TBL_ESTINSCRIT + "(" +
                    COL_ID_OFFRE   + " INTEGER, " +
                    COL_ID_CLIENT  + " INTEGER, " +
                    "PRIMARY KEY (" + COL_ID_OFFRE + ", " + COL_ID_CLIENT + "), " +
                    "FOREIGN KEY (" + COL_ID_OFFRE + ") REFERENCES " + TBL_OFFRE + "(" + COL_ID_OFFRE + "), " +
                    "FOREIGN KEY (" + COL_ID_CLIENT + ") REFERENCES " + TBL_CLIENT + "(" + COL_ID_CLIENT + ")" +
                    ");";
    private static final String DROP_ESTINSCRIT = "DROP TABLE " + TBL_ESTINSCRIT + ";";

    private static final String CREATE_CLIENT =
            "CREATE TABLE " + TBL_CLIENT + "(" +
                    COL_IDC    + " INTEGER PRIMARY KEY AUTOINCREMENT, " +
                    COL_NOM    + " TEXT NOT NULL, " +
                    COL_PRENOM + " TEXT NOT NULL, " +
                    COL_EMAIL  + " TEXT NOT NULL " +
                    ");";
    private static final String DROP_CLIENT = "DROP TABLE " + TBL_CLIENT + ";";

    /** Constructeur */
    public GestionAchatsOpenHelper (Context context, String name, CursorFactory factory, int version) {
        super(context, name, factory, version);
    } // Constructeur

    @Override
    /* Lors de la premi�re cr�ation de la base: cr�er les tables et ins�rer les donn�es de test. */
    public void onCreate (SQLiteDatabase db) {
        db.execSQL(CREATE_OFFRE);
        db.execSQL(CREATE_CLIENT);
        db.execSQL(CREATE_ESTINSCRIT);
        insereDonnees(db);
    } // onCreate

    @Override
    /* Lors de la mise � jour de la base avec une nouvelle version: supprimer les tables et recr�er la base originale. */
    public void onUpgrade (SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL(DROP_ESTINSCRIT);
        db.execSQL(DROP_CLIENT);
        db.execSQL(DROP_OFFRE);
        onCreate(db);
    } // onUpgrade

    /* Ins�re les donn�es dans la base */
    private void insereDonnees (SQLiteDatabase db) {
        /* Table Offre */
        ContentValues val = new ContentValues();
        val.put(COL_IDO, 1); val.put(COL_LIBELLE, "Camescope Samsung"); val.put(COL_PRIX, 95.45); val.put(COL_MIN, 5); val.put(COL_MAX, 10); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 2); val.put(COL_LIBELLE, "Casque Bluetooth Sony"); val.put(COL_PRIX, 44.25); val.put(COL_MIN, 4); val.put(COL_MAX, 9); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 3); val.put(COL_LIBELLE, "Dock pour iPhone 5"); val.put(COL_PRIX, 25.30); val.put(COL_MIN, 7); val.put(COL_MAX, 10); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 4); val.put(COL_LIBELLE, "Massage sportif"); val.put(COL_PRIX, 39.95); val.put(COL_MIN, 6); val.put(COL_MAX, 12); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 5); val.put(COL_LIBELLE, "Entree au zoo Tropicaland"); val.put(COL_PRIX, 8.95); val.put(COL_MIN, 8); val.put(COL_MAX, 18); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 6); val.put(COL_LIBELLE, "Hypnose ecricksonnienne"); val.put(COL_PRIX, 42.00); val.put(COL_MIN, 7); val.put(COL_MAX, 14); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 7); val.put(COL_LIBELLE, "Repas indien au Tigre du Bengale pour 2"); val.put(COL_PRIX, 59.50); val.put(COL_MIN, 12); val.put(COL_MAX, 25); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 8); val.put(COL_LIBELLE, "Sejour detente a Chamonix (2 nuits)"); val.put(COL_PRIX, 159.90); val.put(COL_MIN, 10); val.put(COL_MAX, 15); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 9); val.put(COL_LIBELLE, "Parasol de luxe rouge"); val.put(COL_PRIX, 299.45); val.put(COL_MIN, 5); val.put(COL_MAX, 20); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 10); val.put(COL_LIBELLE, "Planche a decouper en bambou"); val.put(COL_PRIX, 49.50); val.put(COL_MIN, 10); val.put(COL_MAX, 12); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 11); val.put(COL_LIBELLE, "Spa & Detente a Saxon (3 nuits)"); val.put(COL_PRIX, 339.10); val.put(COL_MIN, 4); val.put(COL_MAX, 8); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 12); val.put(COL_LIBELLE, "Disneyland Paris (4 jours)"); val.put(COL_PRIX, 449.05); val.put(COL_MIN, 5); val.put(COL_MAX, 10); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 13); val.put(COL_LIBELLE, "Refrigerateur Bosch KTS 102"); val.put(COL_PRIX, 729.35); val.put(COL_MIN, 3); val.put(COL_MAX, 12); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 14); val.put(COL_LIBELLE, "Lave-Vaisselle Miele Active Clean"); val.put(COL_PRIX, 629.65); val.put(COL_MIN, 8); val.put(COL_MAX, 20); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 15); val.put(COL_LIBELLE, "Aspirateur Dyson DC 29"); val.put(COL_PRIX, 269.10); val.put(COL_MIN, 6); val.put(COL_MAX, 20); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 16); val.put(COL_LIBELLE, "Armoire a chaussures 32 paires"); val.put(COL_PRIX, 259.15); val.put(COL_MIN, 4); val.put(COL_MAX, 12); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 17); val.put(COL_LIBELLE, "Commode 2 tiroirs"); val.put(COL_PRIX, 187.20); val.put(COL_MIN, 6); val.put(COL_MAX, 12); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 18); val.put(COL_LIBELLE, "Sweatshirt GAP"); val.put(COL_PRIX, 17.90); val.put(COL_MIN, 20); val.put(COL_MAX, 40); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 19); val.put(COL_LIBELLE, "Ensemble 3 valises Samsonite"); val.put(COL_PRIX, 659.95); val.put(COL_MIN, 5); val.put(COL_MAX, 10); db.insert(TBL_OFFRE, null, val);
        val.put(COL_IDO, 20); val.put(COL_LIBELLE, "Seche-cheveux Braun"); val.put(COL_PRIX, 42.90); val.put(COL_MIN, 10); val.put(COL_MAX, 30); db.insert(TBL_OFFRE, null, val);
        /* Table Client */
        val = new ContentValues();
        val.put(COL_IDC, 1); val.put(COL_NOM, "Dupont"); val.put(COL_PRENOM, "Sam"); val.put(COL_EMAIL, "sam.dupont@bluewin.ch"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 2); val.put(COL_NOM, "Santschi"); val.put(COL_PRENOM, "Naomi"); val.put(COL_EMAIL, "naomi.santschi@econophone.ch"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 3); val.put(COL_NOM, "Mechi"); val.put(COL_PRENOM, "Cyril"); val.put(COL_EMAIL, "cyril.mechi@gmail.com"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 4); val.put(COL_NOM, "Godel"); val.put(COL_PRENOM, "Emilie"); val.put(COL_EMAIL, "emilie.godel@gmail.com"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 5); val.put(COL_NOM, "Schaffter"); val.put(COL_PRENOM, "Cedric"); val.put(COL_EMAIL, "cedric.schaffter@bluewin.ch"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 6); val.put(COL_NOM, "Simeon"); val.put(COL_PRENOM, "Thibault"); val.put(COL_EMAIL, "thibault.simeon@bluewin.ch"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 7); val.put(COL_NOM, "Amruthalingam"); val.put(COL_PRENOM, "Cecilia"); val.put(COL_EMAIL, "cecilia.amruthalingam@lgt.com"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 8); val.put(COL_NOM, "Vasquez"); val.put(COL_PRENOM, "Marie"); val.put(COL_EMAIL, "marie.vasquez@fgc.ch"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 9); val.put(COL_NOM, "Gillard"); val.put(COL_PRENOM, "Martin"); val.put(COL_EMAIL, "martin.gillard@gmail.com"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 10); val.put(COL_NOM, "Uzan"); val.put(COL_PRENOM, "Matteo"); val.put(COL_EMAIL, "matteo.uzan@sunrise.ch"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 11); val.put(COL_NOM, "Borgeaud"); val.put(COL_PRENOM, "Nathan"); val.put(COL_EMAIL, "nathan.borgeaud@bluewin.ch"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 12); val.put(COL_NOM, "Antenen"); val.put(COL_PRENOM, "S�bastien"); val.put(COL_EMAIL, "sebastien.antenen@bluewin.ch"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 13); val.put(COL_NOM, "Uhde"); val.put(COL_PRENOM, "Sarah"); val.put(COL_EMAIL, "sarah.uhde@bluewin.ch"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 14); val.put(COL_NOM, "Lueber"); val.put(COL_PRENOM, "Nelson"); val.put(COL_EMAIL, "nelson.lueber@yahoo.fr"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 15); val.put(COL_NOM, "Fleury"); val.put(COL_PRENOM, "Keziah"); val.put(COL_EMAIL, "keziah.fleury@bluewin.ch"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 16); val.put(COL_NOM, "Kreis"); val.put(COL_PRENOM, "Tanguy"); val.put(COL_EMAIL, "tanguy.kreis@bluewin.ch"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 17); val.put(COL_NOM, "Weyrich"); val.put(COL_PRENOM, "Flavien"); val.put(COL_EMAIL, "flavien.weyrich@hotmail.com"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 18); val.put(COL_NOM, "Pinto"); val.put(COL_PRENOM, "Camille"); val.put(COL_EMAIL, "camille.pinto@worldcom.ch"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 19); val.put(COL_NOM, "Ding"); val.put(COL_PRENOM, "Sylvain"); val.put(COL_EMAIL, "sylvain.ding@bluewin.ch"); db.insert(TBL_CLIENT, null, val);
        val.put(COL_IDC, 20); val.put(COL_NOM, "Kistler"); val.put(COL_PRENOM, "Laura"); val.put(COL_EMAIL, "laura.kistler@msn.com"); db.insert(TBL_CLIENT, null, val);
        /* Table EstInscrit */
        val = new ContentValues();
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 10); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 5); val.put(COL_ID_CLIENT, 9); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 14); val.put(COL_ID_CLIENT, 9); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 10); val.put(COL_ID_CLIENT, 14); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 18); val.put(COL_ID_CLIENT, 15); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 8); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 19); val.put(COL_ID_CLIENT, 6); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 5); val.put(COL_ID_CLIENT, 1); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 4); val.put(COL_ID_CLIENT, 17); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 7); val.put(COL_ID_CLIENT, 1); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 19); val.put(COL_ID_CLIENT, 7); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 11); val.put(COL_ID_CLIENT, 8); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 11); val.put(COL_ID_CLIENT, 18); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 18); val.put(COL_ID_CLIENT, 2); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 2); val.put(COL_ID_CLIENT, 15); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 16); val.put(COL_ID_CLIENT, 11); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 19); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 18); val.put(COL_ID_CLIENT, 1); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 10); val.put(COL_ID_CLIENT, 2); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 10); val.put(COL_ID_CLIENT, 8); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 19); val.put(COL_ID_CLIENT, 8); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 6); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 4); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 18); val.put(COL_ID_CLIENT, 20); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 11); val.put(COL_ID_CLIENT, 7); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 2); val.put(COL_ID_CLIENT, 10); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 5); val.put(COL_ID_CLIENT, 18); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 1); val.put(COL_ID_CLIENT, 14); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 13); val.put(COL_ID_CLIENT, 3); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 8); val.put(COL_ID_CLIENT, 5); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 20); val.put(COL_ID_CLIENT, 13); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 13); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 18); val.put(COL_ID_CLIENT, 11); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 2); val.put(COL_ID_CLIENT, 13); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 8); val.put(COL_ID_CLIENT, 18); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 18); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 17); val.put(COL_ID_CLIENT, 14); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 14); val.put(COL_ID_CLIENT, 2); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 7); val.put(COL_ID_CLIENT, 9); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 18); val.put(COL_ID_CLIENT, 14); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 17); val.put(COL_ID_CLIENT, 12); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 16); val.put(COL_ID_CLIENT, 12); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 16); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 8); val.put(COL_ID_CLIENT, 15); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 16); val.put(COL_ID_CLIENT, 20); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 2); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 7); val.put(COL_ID_CLIENT, 14); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 18); val.put(COL_ID_CLIENT, 12); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 2); val.put(COL_ID_CLIENT, 9); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 3); val.put(COL_ID_CLIENT, 12); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 20); val.put(COL_ID_CLIENT, 14); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 14); val.put(COL_ID_CLIENT, 11); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 16); val.put(COL_ID_CLIENT, 17); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 3); val.put(COL_ID_CLIENT, 20); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 11); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 20); val.put(COL_ID_CLIENT, 12); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 6); val.put(COL_ID_CLIENT, 3); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 20); val.put(COL_ID_CLIENT, 15); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 12); val.put(COL_ID_CLIENT, 7); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 11); val.put(COL_ID_CLIENT, 12); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 7); val.put(COL_ID_CLIENT, 18); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 3); val.put(COL_ID_CLIENT, 11); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 14); val.put(COL_ID_CLIENT, 15); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 6); val.put(COL_ID_CLIENT, 14); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 14); val.put(COL_ID_CLIENT, 8); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 10); val.put(COL_ID_CLIENT, 11); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 16); val.put(COL_ID_CLIENT, 14); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 17); val.put(COL_ID_CLIENT, 7); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 1); val.put(COL_ID_CLIENT, 6); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 10); val.put(COL_ID_CLIENT, 15); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 13); val.put(COL_ID_CLIENT, 16); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 5); val.put(COL_ID_CLIENT, 13); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 8); val.put(COL_ID_CLIENT, 10); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 2); val.put(COL_ID_CLIENT, 19); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 1); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 11); val.put(COL_ID_CLIENT, 4); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 20); val.put(COL_ID_CLIENT, 11); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 4); val.put(COL_ID_CLIENT, 16); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 19); val.put(COL_ID_CLIENT, 10); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 10); val.put(COL_ID_CLIENT, 3); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 3); val.put(COL_ID_CLIENT, 18); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 4); val.put(COL_ID_CLIENT, 1); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 18); val.put(COL_ID_CLIENT, 3); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 14); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 20); val.put(COL_ID_CLIENT, 20); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 2); val.put(COL_ID_CLIENT, 6); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 16); val.put(COL_ID_CLIENT, 7); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 4); val.put(COL_ID_CLIENT, 20); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 13); val.put(COL_ID_CLIENT, 5); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 12); val.put(COL_ID_CLIENT, 9); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 10); val.put(COL_ID_CLIENT, 20); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 15); val.put(COL_ID_CLIENT, 7); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 3); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 7); val.put(COL_ID_CLIENT, 17); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 14); val.put(COL_ID_CLIENT, 18); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 16); val.put(COL_ID_CLIENT, 4); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 12); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 16); val.put(COL_ID_CLIENT, 5); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 14); val.put(COL_ID_CLIENT, 10); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 17); val.put(COL_ID_CLIENT, 19); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 11); val.put(COL_ID_CLIENT, 10); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 17); val.put(COL_ID_CLIENT, 17); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 14); val.put(COL_ID_CLIENT, 13); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 5); val.put(COL_ID_CLIENT, 11); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 14); val.put(COL_ID_CLIENT, 3); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 4); val.put(COL_ID_CLIENT, 19); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 13); val.put(COL_ID_CLIENT, 6); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 10); val.put(COL_ID_CLIENT, 10); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 7); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 11); val.put(COL_ID_CLIENT, 14); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 10); val.put(COL_ID_CLIENT, 13); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 14); val.put(COL_ID_CLIENT, 17); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 17); val.put(COL_ID_CLIENT, 9); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 2); val.put(COL_ID_CLIENT, 18); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 16); val.put(COL_ID_CLIENT, 16); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 13); val.put(COL_ID_CLIENT, 17); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 16); val.put(COL_ID_CLIENT, 6); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 7); val.put(COL_ID_CLIENT, 7); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 12); val.put(COL_ID_CLIENT, 6); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 15); val.put(COL_ID_CLIENT, 8); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 5); val.put(COL_ID_CLIENT, 10); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 17); val.put(COL_ID_CLIENT, 6); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 14); val.put(COL_ID_CLIENT, 12); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 10); val.put(COL_ID_CLIENT, 18); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 17); val.put(COL_ID_CLIENT, 16); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 13); val.put(COL_ID_CLIENT, 4); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 17); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 3); val.put(COL_ID_CLIENT, 9); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 20); val.put(COL_ID_CLIENT, 16); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 10); val.put(COL_ID_CLIENT, 1); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 4); val.put(COL_ID_CLIENT, 2); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 4); val.put(COL_ID_CLIENT, 14); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 5); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 1); val.put(COL_ID_CLIENT, 8); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 2); val.put(COL_ID_CLIENT, 8); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 12); val.put(COL_ID_CLIENT, 8); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 10); val.put(COL_ID_CLIENT, 16); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 9); val.put(COL_ID_CLIENT, 9); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 4); val.put(COL_ID_CLIENT, 8); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 1); val.put(COL_ID_CLIENT, 11); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 2); val.put(COL_ID_CLIENT, 11); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 4); val.put(COL_ID_CLIENT, 3); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 8); val.put(COL_ID_CLIENT, 4); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 8); val.put(COL_ID_CLIENT, 14); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 5); val.put(COL_ID_CLIENT, 16); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 17); val.put(COL_ID_CLIENT, 20); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 16); val.put(COL_ID_CLIENT, 13); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 11); val.put(COL_ID_CLIENT, 5); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 13); val.put(COL_ID_CLIENT, 7); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 13); val.put(COL_ID_CLIENT, 19); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 19); val.put(COL_ID_CLIENT, 9); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 19); val.put(COL_ID_CLIENT, 20); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 6); val.put(COL_ID_CLIENT, 4); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 15); val.put(COL_ID_CLIENT, 6); db.insert(TBL_ESTINSCRIT, null, val);
        val.put(COL_ID_OFFRE, 3); val.put(COL_ID_CLIENT, 4); db.insert(TBL_ESTINSCRIT, null, val);
    } // insereDonnees


}//GestionAchatsOpenHelper
