package ch.parrado.android.groopy.domaine;

/**
 * Emploi de la base de donnees SQLite - Gestion d'achats groupes
 *
 * Modelisation d'un client
 *
 */
public class Client implements Comparable<Client> {

    private int id;
    private String nom;
    private String prenom;
    private String eMail;

    public Client (int id, String nom, String prenom, String eMail) {
        this.id = id; this.nom = nom; this.prenom = prenom; this.eMail = eMail;
    } // Constructeur

    public int getId () {return id;}
    public String getNom () {return nom;}
    public String getPrenom () {return prenom;}
    public String getEMail () {return eMail;}

    public boolean equals (Object obj) {return ((Client)obj).id == id;}

    public int compareTo (Client c) {
        int res = nom.compareTo(c.nom);
        return (res != 0) ? res : prenom.compareTo(c.prenom);
    } // compareTo

    @Override
    public String toString() {
        return "Nom : " + nom + "   Prenom : " + prenom ;
    }
} // Client
