package ch.parrado.android.groopy.domaine;

import java.io.Serializable;

/**
 * Emploi de la base de donnees SQLite - Gestion d'achats groupes
 *
 * Modelisation d'une offre
 *
 */
public class Offre implements Comparable<Offre>, Serializable {

    private int id;              /* Identifiant */
    private String libelle;      /* Libell� de l'offre */
    private double prix;         /* Prix */
    private int minInscrits;     /* Nombres minimal d'inscrits necessaires pour que l'offre soit validee */
    private int maxInscrits;     /* Nombre maximal d'inscrits possibles pour cette offre */
    private int inscritsActuels; /* Nombre de clients inscrits actuellement � cette offre (0 <= inscritsActuels <= maxInscrits) */

    public Offre (int id, String libelle, double prix, int minInscrits, int maxInscrits, int inscritsActuels) {
        this.id = id; this.libelle = libelle; this.prix = prix; this.minInscrits = minInscrits; this.maxInscrits = maxInscrits;
        this.inscritsActuels = inscritsActuels;
    } // Constructeur

    public int getId () {return id;}
    public String getLibelle () {return libelle;}
    public double getPrix () {return prix;}
    public int getMinInscrits () {return minInscrits;}
    public int getMaxInscrits () {return maxInscrits;}
    public int getInscritsActuels () {return inscritsActuels;}

    public boolean equals (Object obj) {return ((Offre)obj).id == id;}

    public int compareTo (Offre o) {return libelle.compareTo(o.libelle);}

} // Offre