package ch.parrado.android.groopy.metier;

import java.util.ArrayList;
import java.util.TreeSet;

import ch.parrado.android.groopy.R;
import ch.parrado.android.groopy.domaine.Client;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.TextView;

/**
 * Emploi de la base de donnees SQLite - Gestion d'achats groupes
 *
 * Adaptateur personalise - les Clients
 *
 * @author Nicolas Parrado
 */

public class ClientAdapter extends BaseAdapter {

    private ArrayList<Client> data;      /* Informations a representer */
    private Context context;         	   /* Contexte */
    //private LayoutInflater inflater; /* Outil de creation d'une vue "layout" a partir de sa description XML */
    private TreeSet<Integer> lstAEffacer; /* Liste des items a effacer (a cocher)*/

    public ClientAdapter (Context context, ArrayList<Client> data, TreeSet<Integer> lstAEffacer) {
        this.data = data;
        this.context = context;
        //inflater = LayoutInflater.from(context);
        this.lstAEffacer = lstAEffacer;
    } //Constructeur

    /* Modelisation d'une ligne */
    public static class LigneClient extends LinearLayout {
        TextView tvNomPrenom, tvEMail;
        CheckBox ckChoisi;

        public CheckBox getCkChoisi() {return ckChoisi;}

        public void setCkChoisi(CheckBox ckChoisi) {this.ckChoisi = ckChoisi;}

        LigneClient (Context context, int layoutId) {
            super(context);
            LayoutInflater.from(context).inflate(layoutId, this);
            tvNomPrenom = (TextView)findViewById(R.id.tvNomPrenom);
            tvEMail = (TextView)findViewById(R.id.tvEMail);
            ckChoisi = (CheckBox)findViewById(R.id.ckChoisi);
        } // Constructeur

    }// Ligne

    /** Retourne le nombre d'items a representer */
    public int getCount () {return data.size();}

    /** Retourne l'item d'indice position */
    public Object getItem (int position) {return data.get(position);}

    /** Retourne un identifiant pour l'item d'indice position */
    public long getItemId (int position) {return position;}

    /** Retourne la vue qui affiche l'item d'indice position */
    public View getView (int position, View convertView, ViewGroup parent) {
        if (convertView == null) {convertView = new LigneClient(context, R.layout.client);}

        LigneClient lig = (LigneClient)convertView;
        Client client = data.get(position);
        lig.tvNomPrenom.setText(client.getNom() + " " + client.getPrenom());
        lig.tvEMail.setText(client.getEMail());
        lig.ckChoisi.setEnabled(lstAEffacer.contains(position));// On coche ceux de la lstAEffacer
        return convertView;
    } // getView

}// ClientAdapter