package ch.parrado.android.groopy.metier;

import java.util.ArrayList;

import ch.parrado.android.groopy.R;
import ch.parrado.android.groopy.domaine.Offre;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;

/**
 * Emploi de la base de donnees SQLite - Gestion d'achats groupes
 *
 * Adaptateur personalise - les Offres qui sont completes ne sont pas affiche comme les autres
 *
 * @author Nicolas Parrado
 */

public class OffreAdapter extends BaseAdapter {

    private static final int VUE_INCOMPLETE = 0, VUE_VALIDEE = 1; /* Les deux types de vues gerees */

    private static String libManque, libInscript, libInsPoss; /* Libelles pour l'affichage */

    private ArrayList<Offre> data;      /* Informations a representer */
    //private LayoutInflater inflater; /* Outil de creation d'une vue "layout" a partir de sa description XML */
    private Context context;         /* Contexte */

    public OffreAdapter (Context context, ArrayList<Offre> data) {
        this.data = data;
        this.context = context;
        libManque = context.getResources().getString(R.string.libManque);
        libInscript = context.getResources().getString(R.string.libInscript);
        libInsPoss = context.getResources().getString(R.string.libInsPoss);


    }// constructeur

    /** Retourne le nombre d'items a representer */
    public int getCount () {return data.size();}

    /** Retourne l'item d'indice position */
    public Object getItem (int position) {return data.get(position);}

    /** Retourne un identifiant pour l'item d'indice position */
    public long getItemId (int position) {return position;}

    @Override
    /** Retourne le nombre de types differents de vues constituant la liste */
    public int getViewTypeCount () {return 2;}

    @Override
    /** Retourne le type de vue qui doit etre employee pour representer les informations de la ligne position */
    public int getItemViewType (int position) {
        Offre offre = data.get(position);
        if (offre.getInscritsActuels()< offre.getMinInscrits() ||
                offre.getInscritsActuels() > offre.getMaxInscrits()) {
            return VUE_INCOMPLETE;} else {return VUE_VALIDEE;
        }//if else
    } // getItemViewType

    /* Modelisation d'une ligne representant une Offre incomplete */
    private static class LigneIncomplete extends LinearLayout {
        TextView tvLibIncomplete, tvManque;

        LigneIncomplete (Context context, int layoutId) {
            super(context);
            LayoutInflater.from(context).inflate(layoutId, this);
            tvLibIncomplete = (TextView)findViewById(R.id.tvLibIncomplete);
            tvManque = (TextView)findViewById(R.id.tvManque);
        } // Constructeur

    } // LigneIncomplete

    /* Mod�lisation d'une ligne repr�sentant une Offre valid�e */
    private static class LigneValidee extends LinearLayout {
        TextView tvLibValidee, tvPossibles;

        LigneValidee (Context context, int layoutId) {
            super(context);
            LayoutInflater.from(context).inflate(layoutId, this);
            tvLibValidee = (TextView)findViewById(R.id.tvLibValidee);
            tvPossibles = (TextView)findViewById(R.id.tvPossibles);
        } // Constructeur

    } // LigneValidee

    /** Retourne la vue qui affiche l'item d'indice position */
    public View getView (int position, View convertView, ViewGroup parent) {
        int viewType = getItemViewType(position);
        if (convertView == null) {
            switch (viewType) {
                case VUE_INCOMPLETE:
                    convertView = new LigneIncomplete(context, R.layout.offre_incomplete);
                    LigneIncomplete ligInc = (LigneIncomplete)convertView;
                    Offre offreInc = data.get(position);
                    ligInc.tvLibIncomplete.setText(offreInc.getLibelle());
                    int nbManque = offreInc.getMinInscrits() - offreInc.getInscritsActuels();
                    ligInc.tvManque.setText(libManque +" "+ nbManque +" "+ libInscript);
                    break;

                case VUE_VALIDEE:
                    convertView = new LigneValidee(context, R.layout.offre_validee);
                    LigneValidee ligVal = (LigneValidee)convertView;
                    Offre offreVal = data.get(position);
                    ligVal.tvLibValidee.setText(offreVal.getLibelle());
                    int nbPossible = offreVal.getMaxInscrits() - offreVal.getInscritsActuels();
                    ligVal.tvPossibles.setText(libInsPoss +" "+ nbPossible);
                    break;
            }//switch
        }//if
        return convertView;
    } // getView

}// OffreAdapter