package ch.parrado.android.groopy.presentation;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.TreeSet;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.AdapterView.OnItemLongClickListener;

import ch.parrado.android.groopy.R;
import ch.parrado.android.groopy.domaine.Offre;
import ch.parrado.android.groopy.domaine.Client;
import ch.parrado.android.groopy.base.GestionAchatsDao;
import ch.parrado.android.groopy.metier.ClientAdapter;
import ch.parrado.android.groopy.metier.ClientAdapter.LigneClient;

/**
 * Emploi de la base de donnees SQLite - Gestion d'achats groupes
 *
 * Activite de gestion des inscrits a l'offre actuelle
 *
 * @author Nicolas Parrado
 */
public class GestionInscritsActivity extends Activity {

    /* Contreles */
    private TextView tvLibelle;
    private EditText etPrix, etMin, etMax, etAct;
    private Button btnSupprimer, btnNouveau;
    private ListView lvClients;

    private Offre offreActu; //offre transmis par par MainActivity

    /* Le format decimal */
    DecimalFormat format = new DecimalFormat("0.00");

    /* Liste des id des Clients a effacer */
    private TreeSet<Integer> lstAEffacer = new TreeSet<Integer>();

    private void definirVariables () {
        tvLibelle = (TextView)findViewById(R.id.tvLibelle);
        etPrix = (EditText)findViewById(R.id.etPrix);
        etMin = (EditText)findViewById(R.id.etMin);
        etMax = (EditText)findViewById(R.id.etMax);
        etAct = (EditText)findViewById(R.id.etAct);
        btnSupprimer = (Button)findViewById(R.id.btnSupprimer);
        btnNouveau = (Button)findViewById(R.id.btnNouveau);
        lvClients = (ListView)findViewById(R.id.lvClients);
    } // definirVariables

    private void definirListner() {
        lvClients.setOnItemLongClickListener(new OnItemLongClickListener() {
            public boolean onItemLongClick(AdapterView<?> parent, View v, int position, long id) {
                LigneClient lig = (LigneClient) v; //recuperation de la ligne (view sur la quel on a clique)
                CheckBox ckb = lig.getCkChoisi();
                if (ckb.isChecked()){
                    ckb.setChecked(false);
                    lstAEffacer.remove(position);
                }else{
                    ckb.setChecked(true);
                    lstAEffacer.add(position);
                }
                gererBtnSupprimer();
                return true;
            }
        });//lvClients.setOnItemLongClickListener
    }//definirListner

    /* Listener de btnSupprimer */
    public void supprimer (View v) {
        Toast.makeText(getApplicationContext(), getResources().getString(R.string.libEnCours), Toast.LENGTH_LONG).show();Toast.makeText(getApplicationContext(), getResources().getString(R.string.libEnCours), Toast.LENGTH_LONG).show();Toast.makeText(getApplicationContext(), getResources().getString(R.string.libEnCours), Toast.LENGTH_LONG).show();Toast.makeText(getApplicationContext(), getResources().getString(R.string.libEnCours), Toast.LENGTH_LONG).show(); } // supprimer

    /* Listener de btnNouveau */
    public void nouveau (View v) {
        Toast.makeText(getApplicationContext(), getResources().getString(R.string.libEnCours), Toast.LENGTH_LONG).show();
    } // nouveau

    /** Affiche la liste des Clients pour une offre d'id */
    public void chargerListeClients(int id){
        GestionAchatsDao base = new GestionAchatsDao(getApplicationContext());
        base.open();
        ArrayList<Client> lstClients = base.getListeClients(id);
        base.close();
        ClientAdapter adapter = new ClientAdapter(getApplicationContext(), lstClients, lstAEffacer);
        lvClients.setAdapter(adapter);
    }// chargerListeClients

    public void afficherDetails (){
        tvLibelle.setText(offreActu.getLibelle());
        etPrix.setText(format.format(offreActu.getPrix()));
        etMin.setText(Integer.toString(offreActu.getMinInscrits()));
        etMax.setText(Integer.toString(offreActu.getMaxInscrits()));
        etAct.setText(Integer.toString(offreActu.getInscritsActuels()));
    }// afficherDetails

    public void gererBtnSupprimer() {
        btnSupprimer.setEnabled(!lstAEffacer.isEmpty());
    }// gererBtnSupprimer


    @Override
    protected void onCreate (Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.inscrits);
        definirVariables();
        definirListner();
        Bundle extra = getIntent().getExtras();
        if (extra != null) {
            offreActu = (Offre)extra.get("offre");
            int id = (Integer)extra.get("id");
            //chargerListeClients(id);
            chargerListeClients(9);
            afficherDetails();
        }//if
        gererBtnSupprimer();
    } // onCreate

} // GestionInscritsActivity
