package ch.parrado.android.groopy.presentation;


import java.text.DecimalFormat;
import java.util.ArrayList;


import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemLongClickListener;

import ch.parrado.android.groopy.R;
import ch.parrado.android.groopy.domaine.Offre;
import ch.parrado.android.groopy.base.GestionAchatsDao;
import ch.parrado.android.groopy.metier.OffreAdapter;

/**
 * Emploi de la base de donnees SQLite - Gestion d'achats groupes
 *
 * Activite principale: affichage des offres
 *
 * @author Nicolas Parrado
 */
public class MainActivity extends Activity {

    private static final int ETAT_INIT = 0;
    private static final int ETAT_DETAIL = 1;

    /* Le format decimal */
    DecimalFormat format = new DecimalFormat("0.00");

    /* Controles */
    private TextView tvLibelle;
    private EditText etPrix, etMin, etMax, etAct;
    private ListView lvOffres;
    private LinearLayout layDetail;

    ArrayList<Offre> lstOffres;

    private void definirVariables () {
        tvLibelle = (TextView)findViewById(R.id.tvLibelle);
        etPrix = (EditText)findViewById(R.id.etPrix);
        etMin = (EditText)findViewById(R.id.etMin);
        etMax = (EditText)findViewById(R.id.etMax);
        etAct = (EditText)findViewById(R.id.etAct);
        lvOffres = (ListView)findViewById(R.id.lvOffres);
        layDetail = (LinearLayout)findViewById(R.id.layDetail);
    } // definirVariables

    private void definirListners () {
        lvOffres.setOnItemClickListener(new OnItemClickListener() {
            public void onItemClick(AdapterView<?> parent, View v, int position, long id) {
                Offre offre = (Offre)parent.getItemAtPosition(position);
                afficherDetails(offre);
                setEtat(ETAT_DETAIL);
            }
        });// lvOffres.setOnItemClickListener

        lvOffres.setOnItemLongClickListener(new OnItemLongClickListener() {
            public boolean onItemLongClick(AdapterView<?> parent, View v, int position, long id) {
                Offre offre = (Offre)parent.getItemAtPosition(position);

                int idO = offre.getId();
                String lib = offre.getLibelle();
                Double prix = offre.getPrix();
                int minInscrits = offre.getMinInscrits();
                int maxInscrits = offre.getMaxInscrits();
                int inscritsActuels = offre.getInscritsActuels();

                Intent intent = new Intent(getApplicationContext(),GestionInscritsActivity.class);
                intent.putExtra("id", idO);
                intent.putExtra("lib", lib);
                intent.putExtra("prix", prix);
                intent.putExtra("minInscrits", minInscrits);
                intent.putExtra("maxInscrits", maxInscrits);
                intent.putExtra("inscritsActuels", inscritsActuels);
                intent.putExtra("offre", offre); //Serializable
                startActivity(intent);
                return true;
            }
        });//lvPersonnes.setOnItemLongClickListener
    }//definirListners

    /** Configure l'affichage des elements selon l'etat voulu */
    private void setEtat(int etat) {
        switch (etat) {
            case 0 :
                layDetail.setVisibility(View.GONE);
                break;

            case 1 :
                layDetail.setVisibility(View.VISIBLE);
                break;
        }
    }// setEtat

    /** Charge les offres dans la liste d'offres a afficher */
    private void chargerListeOffres () {
        GestionAchatsDao base = new GestionAchatsDao(getApplicationContext());
        base.open();
        lstOffres = base.getListeOffres();
        base.close();
        OffreAdapter adapter = new OffreAdapter(getApplicationContext(), lstOffres);
        lvOffres.setAdapter(adapter);
    } // chargerListeOffres


    private void afficherDetails(Offre o){
        tvLibelle.setText(o.getLibelle());
        etPrix.setText(format.format(o.getPrix()));
        etMin.setText(Integer.toString(o.getMinInscrits()));
        etMax.setText(Integer.toString(o.getMaxInscrits()));
        etAct.setText(Integer.toString(o.getInscritsActuels()));
    }// afficherDetails

    @Override
    protected void onCreate (Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        System.out.print("Debut du programme d'achat");
        definirVariables();
        definirListners();
        setEtat(ETAT_INIT);
        chargerListeOffres();
    } // onCreate

} // MainActivity

