﻿Imports BookMe.ModBDD
Imports Oracle.DataAccess.Client

Public Class frmMain

    Dim isAdmin As Boolean

    'Setteur du boolean isAdmin
    Public Sub SetIsAdmin(ByVal boo As Boolean)
        isAdmin = boo
    End Sub

    '===========================
    '=      EVENEMENTS         =
    '===========================

    'Au chargement
    Private Sub frmMain_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        'Connection à la BDD
        connection()
        Me.Enabled = False
        'Si la réponse de la Boite de diaglogue (login) a quité en cliquant sur OK
        If frmlogin.ShowDialog(Me) = DialogResult.OK Then
            Init()
        End If

    End Sub

    'A la fermeture de la fenêtre
    Private Sub frmMain_FormClosing(sender As Object, e As FormClosingEventArgs) Handles Me.FormClosing
        'Déconnection de la BDD
        deconnection()
    End Sub

    'Rafraichissement de l'onglet qu'on demande d'afficher
    Private Sub TabControl_SelectedIndexChanged(sender As Object, e As EventArgs) Handles TabControl.SelectedIndexChanged

        If TabControl.SelectedIndex = TabControl.TabPages.IndexOf(TabLocation) Then
            RefreshTabLocation()
        End If

        If TabControl.SelectedIndex = TabControl.TabPages.IndexOf(TabClient) Then
            RefreshTabClient()
        End If

        If TabControl.SelectedIndex = TabControl.TabPages.IndexOf(TabMateriel) Then
            RefreshTabMateriel()
        End If

        If TabControl.SelectedIndex = TabControl.TabPages.IndexOf(TabArchive) Then
            RefreshTabArchives()
        End If

        If TabControl.SelectedIndex = TabControl.TabPages.IndexOf(TabStat) Then
            RefreshTabStats()
        End If

    End Sub

    '---LOCATION---
    Private Sub TimLocaActu_Tick(sender As Object, e As EventArgs) Handles timLocaActu.Tick
        If TabControl.SelectedIndex = TabControl.TabPages.IndexOf(TabLocation) Then
            RefreshTabLocation()
        End If
    End Sub

    Private Sub btn_nouvelleLocation_Click(sender As Object, e As EventArgs) Handles btnNouvelleLocation.Click
        Me.Enabled = False
        frm_nouvelleLocation.Show()
    End Sub

    Private Sub btnSupprimerLocation_Click(sender As Object, e As EventArgs) Handles btnSupprimerLocation.Click
        If MsgBox("Souhaitez-vous vraiment supprimer cette location ?", MsgBoxStyle.YesNo) = MsgBoxResult.Yes Then
            SupprimerLocation()
            MsgBox("La location a été supprimé.", MsgBoxStyle.Information)
            GererbtnRetourLocation()
            GererbtnSupprimerLocation()
        End If
    End Sub

    Private Sub btnRetourLocation_Click(sender As Object, e As EventArgs) Handles btnRetourLocation.Click

        Select Case MsgBox("Voulez-vous appliquer le tarif Mineur/AVS ?", MsgBoxStyle.YesNoCancel)
            Case MsgBoxResult.Yes
                CalculerPrix(True)
                RetourLocation()
                GererbtnRetourLocation()
                GererbtnSupprimerLocation()
            Case MsgBoxResult.No
                CalculerPrix(False)
                RetourLocation()
                GererbtnRetourLocation()
                GererbtnSupprimerLocation()
        End Select
    End Sub

    Private Sub dgvListeLoca_SelectionChanged(sender As Object, e As EventArgs) Handles dgvListeLoca.SelectionChanged
        AfficherDetailClientLocation()
        AfficherMatLocaActu()
        GererbtnRetourLocation()
    End Sub


    '---CLIENT---

    Private Sub tbRecherche_LostFocus(sender As Object, e As EventArgs) Handles tbRecherche.LostFocus
        'Si tbRecherche est vide
        If tbRecherche.Text.Length = 0 Then
            'le remplir avec ce texte
            tbRecherche.Text = "Recherche"
            AfficherListeClient() 'car la modification du text en "Recherche" lance à nouveau la recherche
            'on sélectionne tout le texte de tbRecherche
            SelectAllTbRecherche()
        End If
        SelectAllTbRecherche()
    End Sub

    Private Sub tbRecherche_Click(sender As Object, e As EventArgs) Handles tbRecherche.Click
        If tbRecherche.Text = "Recherche" Then
            SelectAllTbRecherche()
        End If
    End Sub

    Private Sub tbRecherche_TextChanged(sender As Object, e As EventArgs) Handles tbRecherche.TextChanged
        RechercheClient()
    End Sub

    Private Sub btnNouveauClient_Click(sender As Object, e As EventArgs) Handles btnNouveauClient.Click
        Me.Enabled = False
        frm_nouveauClient.Show()
    End Sub

    Private Sub btnSupprimerClient_Click(sender As Object, e As EventArgs) Handles btnSupprimerClient.Click
        If MsgBox("Souhaitez-vous vraiment supprimer ce client ?", MsgBoxStyle.YesNo) = MsgBoxResult.Yes Then
            SupprimerClient()
        End If
    End Sub

    Private Sub btnModifierClient_Click(sender As Object, e As EventArgs) Handles btnModifierClient.Click
        ModifierClient()
        MsgBox("Le client a été modifié.", MsgBoxStyle.Information)
    End Sub

    Private Sub dgvListeClient_SelectionChanged(sender As Object, e As EventArgs) Handles dgvListeClient.SelectionChanged
        AfficherDetailClient()
        AfficherMatLocaClient()
        GererBtnSupprimerClient()
        GererBtnModifierClient()
    End Sub

    Private Sub cbIsAdmin_CheckedChanged(sender As Object, e As EventArgs) Handles cbIsAdmin.CheckedChanged
        GererEtatCbIsAdmin()
    End Sub


    '---MATERIEL---
    Private Sub btnNouveauMateriel_Click(sender As Object, e As EventArgs) Handles btnNouveauMateriel.Click
        Me.Enabled = False
        frm_nouveauMateriel.Show()
    End Sub

    Private Sub btnSupprimerMateriel_Click(sender As Object, e As EventArgs) Handles btnSupprimerMat.Click
        If MsgBox("Souhaitez-vous vraiment supprimer ce matériel ?", MsgBoxStyle.YesNo) = MsgBoxResult.Yes Then
            SupprimerMateriel()
            'MsgBox("Le matériel a été supprimé.", MsgBoxStyle.Information)
        End If
    End Sub

    Private Sub btnModifierMat_Click(sender As Object, e As EventArgs) Handles btnModifierMat.Click
        ModifierMateriel()
        MsgBox("Le matériel a été modifié.", MsgBoxStyle.Information)
    End Sub

    Private Sub dgvListeMateriel_SelectionChanged(sender As Object, e As EventArgs) Handles dgvListeMateriel.SelectionChanged
        AfficherDetailMat()
        btnSupprimerMat.Enabled = True
        btnModifierMat.Enabled = True
    End Sub

    Private Sub tbMarqueMat_TextChanged(sender As Object, e As EventArgs) Handles tbMarqueMat.TextChanged
        GererBtnModifierMat()
    End Sub

    Private Sub tbTailleMat_TextChanged(sender As Object, e As EventArgs) Handles tbTailleMat.TextChanged
        GererBtnModifierMat()
    End Sub

    Private Sub cbbTypeMat_SelectedIndexChanged(sender As Object, e As EventArgs) Handles cbbTypeMat.SelectedIndexChanged
        GererBtnModifierMat()
    End Sub


    '---ARCHIVE---
    Private Sub btnRestauClient_Click(sender As Object, e As EventArgs) Handles btnRestauClient.Click
        If MsgBox("Souhaitez-vous vraiment Restaurer ce client ?", MsgBoxStyle.YesNo) = MsgBoxResult.Yes Then
            RestaurerClient()
        End If
    End Sub


    '---STATS---

    '---ABOUT---
    Private Sub pbLogoTropTxT_Click(sender As Object, e As EventArgs) Handles pbLogoTropTxT.Click
        System.Diagnostics.Process.Start("http://www.trop.ch")
    End Sub

    Private Sub lklURLTrop_LinkClicked(sender As Object, e As LinkLabelLinkClickedEventArgs) Handles lklURLTrop.LinkClicked
        System.Diagnostics.Process.Start("http://www.trop.ch")
    End Sub


    '===========================
    '= PROCEDURES ET FONCTIONS =
    '===========================

    'Initialise l'affichage et les boutons
    Private Sub Init()
        'on affiche les données du 1er onglet
        RefreshTabLocation()

        'S'il n'est pas admin, on enlève l'onglet "Matériel" et l'onglet "Archive"
        'On cache le libélé du password, sa textbox et la coche admin  
        If Not isAdmin Then
            TabControl.TabPages.Remove(TabMateriel)
            TabControl.TabPages.Remove(TabArchive)
            lblPwdClient.Visible = False
            mtbPwdClient.Visible = False
            cbIsAdmin.Visible = False
        End If

    End Sub

    '----------------------------------------------------------------
    ' ONGLET LOCATION TabLocation
    '----------------------------------------------------------------
    'Réaffichage de l'onglet
    Public Sub RefreshTabLocation()
        AfficherLocationsActu()
        AfficherDetailClientLocation()
        AfficherMatLocaActu()
        GererbtnSupprimerLocation()
        GererbtnRetourLocation()
    End Sub

    'Affiche les location actuelles dans dgvListeLoca
    Private Sub AfficherLocationsActu()
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader
        Dim uneLigne(9) As String

        dgvListeLoca.Focus()
        strRequete = "SELECT loca_no, pers_prenom, loca_heureDebut, loca_heureFin, pers_no, pers_nom, pers_tel, pers_adresse, pers_mail FROM vw_locaClient WHERE loca_isArchive = 0 ORDER BY loca_heureFin"
        do_sql(strRequete, reader_Sql)
        dgvListeLoca.Rows.Clear()
        While (reader_Sql.Read)
            uneLigne(0) = reader_Sql.Item(0).ToString                       'loca_no
            uneLigne(1) = reader_Sql.Item(1).ToString                       'pers_prenom
            uneLigne(2) = Format(reader_Sql.Item(2), "dd.MM.yyyy HH:mm")    'loca_heureDebut
            uneLigne(3) = Format(reader_Sql.Item(3), "dd.MM.yyyy HH:mm")    'loca_heureFin
            uneLigne(4) = reader_Sql.Item(4).ToString                       'pers_no
            uneLigne(5) = reader_Sql.Item(5).ToString                       'pers_nom
            uneLigne(6) = reader_Sql.Item(6).ToString                       'pers_tel
            uneLigne(7) = reader_Sql.Item(7).ToString                       'pers_adresse
            uneLigne(8) = reader_Sql.Item(8).ToString                       'pers_mail
            dgvListeLoca.Rows.Add(uneLigne)
        End While
        If dgvListeLoca.Rows.Count <> 0 Then
            dgvListeLoca.Rows(0).Selected = True
        End If
        ColorierLignesLoca()
    End Sub

    'Change la couleur du texte de la ligne en fonction de l'heure d'arrivé et de l'heure actuelle
    Private Sub ColorierLignesLoca()
        If dgvListeLoca.Rows.Count <> 0 Then
            Dim strRequete As String
            Dim reader_Sql As OracleDataReader

            For index = 0 To dgvListeLoca.Rows.Count - 1
                'En retard : heure de fin plus petite que Now
                If dgvListeLoca.Rows.Item(index).Cells.Item(3).Value <= DateAndTime.Now Then
                    dgvListeLoca.Rows.Item(index).DefaultCellStyle.ForeColor = Color.Red
                    dgvListeLoca.Rows.Item(index).DefaultCellStyle.SelectionForeColor = Color.MediumVioletRed
                    'A commencé : Heure de fin plus grande et heure de début plus petite
                ElseIf dgvListeLoca.Rows.Item(index).Cells.Item(2).Value <= DateAndTime.Now Then
                    dgvListeLoca.Rows.Item(index).DefaultCellStyle.ForeColor = Color.Green
                    dgvListeLoca.Rows.Item(index).DefaultCellStyle.SelectionForeColor = Color.LightGreen
                Else 'Reservation (dans le futur)
                    dgvListeLoca.Rows.Item(index).DefaultCellStyle.ForeColor = SystemColors.WindowText
                    dgvListeLoca.Rows.Item(index).DefaultCellStyle.SelectionForeColor = SystemColors.HighlightText
                End If
            Next
        End If
    End Sub

    'Affiche les info sur le prenneur de la location sélectionnée dans les champs appropriés
    Private Sub AfficherDetailClientLocation()
        If dgvListeLoca.Rows.Count <> 0 Then
            tbNoClientLoca.Text = dgvListeLoca.CurrentRow.Cells.Item(4).Value.ToString
            tbNomLoca.Text = dgvListeLoca.CurrentRow.Cells.Item(5).Value.ToString
            tbPrenomLoca.Text = dgvListeLoca.CurrentRow.Cells.Item(1).Value.ToString
            tbTelephoneLoca.Text = dgvListeLoca.CurrentRow.Cells.Item(6).Value.ToString
            tbAdresseLoca.Text = dgvListeLoca.CurrentRow.Cells.Item(7).Value.ToString
            tbMailLoca.Text = dgvListeLoca.CurrentRow.Cells.Item(8).Value.ToString
            ColorierClientEfface()
        End If
    End Sub

    'Change la couleur de fond du nom, du prenom et du numéro si le client a été effacé (archivé)
    Private Sub ColorierClientEfface()
        If tbNoClientLoca.Text.Length <> 0 Then
            Dim strRequete As String
            Dim reader_Sql As OracleDataReader

            strRequete = "SELECT pers_isArchive FROM vw_persMod WHERE pers_no = " + tbNoClientLoca.Text
            do_sql(strRequete, reader_Sql)
            reader_Sql.Read()
            If reader_Sql.Item(0) = 1 Then
                tbNoClientLoca.BackColor = Color.Orange
                tbNomLoca.BackColor = Color.Orange
                tbPrenomLoca.BackColor = Color.Orange
            Else
                tbNoClientLoca.BackColor = SystemColors.Control
                tbNomLoca.BackColor = SystemColors.Control
                tbPrenomLoca.BackColor = SystemColors.Control
            End If
        End If
    End Sub

    'Affiche dans dgvMatLoca le matériel utilisé pour la location sélectionnée dans dgvListeLoca
    Private Sub AfficherMatLocaActu()

        If dgvListeLoca.Rows.Count <> 0 Then
            Dim strRequete As String
            Dim reader_Sql As OracleDataReader
            Dim uneLigne(4) As String

            dgvMatLoca.Focus()                                                       ' vw : UNION ALL de bm_matPV et bm_matPad
            strRequete = "SELECT stock_no, stock_type, stock_marque, stock_taille FROM vw_matLoca WHERE loca_no = " + dgvListeLoca.CurrentRow.Cells.Item(0).Value + " ORDER BY stock_type"
            do_sql(strRequete, reader_Sql)
            dgvMatLoca.Rows.Clear()
            While (reader_Sql.Read)
                uneLigne(0) = reader_Sql.Item(0)          'stock_no
                uneLigne(1) = reader_Sql.Item(1).ToString 'stock_type
                uneLigne(2) = reader_Sql.Item(2).ToString 'stock_marque
                uneLigne(3) = reader_Sql.Item(3)          'stock_taille
                dgvMatLoca.Rows.Add(uneLigne)
            End While
            If dgvMatLoca.Rows.Count <> 0 Then
                dgvMatLoca.Rows(0).Selected = True
                ColorierMatEfface()
            End If
        End If
    End Sub

    'Change la couleur du texte de la ligne selon si le matériel a été supprimé (archivé) ou non
    Private Sub ColorierMatEfface()
        If dgvMatLoca.Rows.Count <> 0 Then
            For index = 0 To dgvMatLoca.Rows.Count - 1
                Dim strRequete As String
                Dim reader_Sql As OracleDataReader
                strRequete = "SELECT stock_isArchive FROM vw_stockMod WHERE stock_no = " + dgvMatLoca.Rows.Item(index).Cells.Item(0).Value.ToString
                do_sql(strRequete, reader_Sql)
                reader_Sql.Read()
                'si l'item à cette ligne de dgvMatLoca a déjà été archivé (=1)
                If reader_Sql.Item(0) = 1 Then
                    dgvMatLoca.Rows.Item(index).DefaultCellStyle.ForeColor = Color.Red
                    dgvMatLoca.Rows.Item(index).DefaultCellStyle.SelectionForeColor = Color.Red
                Else
                    dgvMatLoca.Rows.Item(index).DefaultCellStyle.ForeColor = SystemColors.WindowText
                    dgvMatLoca.Rows.Item(index).DefaultCellStyle.SelectionForeColor = SystemColors.WindowText
                End If
            Next
        End If
    End Sub

    'Supprime la location -> TRIGGER sur bm_loca supprime le(s) groupe(s) de matériel correspondant à location sélectionnée (dans bm_matPV et bm_matPad)
    'Le matériel n'est plus en location
    Private Sub SupprimerLocation()
        Dim reader_Sql As OracleDataReader
        Dim strRequete As String

        'Supprime la location -> TRIGGER supprime les groupes de matériel correspondant à cette location
        strRequete = "DELETE FROM vw_locaMod WHERE loca_no = " + dgvListeLoca.CurrentRow.Cells.Item(0).Value
        do_sql(strRequete, reader_Sql)

        ViderDetailClientLocation()

        RefreshTabLocation()

    End Sub
    'Vide tous les champs du DetailClientLocation
    Private Sub ViderDetailClientLocation()
        tbNoClientLoca.Text = ""
        tbNomLoca.Text = ""
        tbPrenomLoca.Text = ""
        tbTelephoneLoca.Text = ""
        tbAdresseLoca.Text = ""
        tbMailLoca.Text = ""
        dgvMatLoca.Rows.Clear()
    End Sub
    'Effectue le retour d'une location : Le matériel de la location n'est plus en location et la location est archivée
    Private Sub RetourLocation()
        Dim reader_Sql As OracleDataReader
        Dim strRequete As String

        'Modifie la location (dans bm_loca) et la met comme archivée (loca_isArchive = 1)
        strRequete = "UPDATE vw_locaMod SET loca_isArchive = 1 WHERE loca_no = " + dgvListeLoca.CurrentRow.Cells.Item(0).Value
        do_sql(strRequete, reader_Sql)

        RefreshTabLocation()
    End Sub

    'Calcule et affiche le prix de la location selon si le tarif normal ou mineur/AVS
    Private Sub CalculerPrix(ByVal isMineurAVS As Boolean)
        Dim tot As Double = 0

        For Each row As DataGridViewRow In dgvMatLoca.Rows
            If Not row.IsNewRow Then
                Select Case row.Cells.Item(1).Value.ToString.ToLower
                    Case "planche" 'il y a 1 planche pour 1 voile. -> nous n'avons donc besoins que de compter les planches p.ex
                        If isMineurAVS Then
                            tot += 24.0
                        Else
                            tot += 29.0
                        End If
                    Case "paddle"
                        If isMineurAVS Then
                            tot += 15.0
                        Else
                            tot += 20.0
                        End If
                End Select

            End If
        Next
        Dim duree As Long = DateDiff(DateInterval.Hour, dgvListeLoca.CurrentRow.Cells.Item(2).Value, dgvListeLoca.CurrentRow.Cells.Item(3).Value)
        tot = tot * duree 'total pour 1 heure * la durée
        MsgBox("Le montant total pour cette location est : " + FormatNumber(Math.Round(tot, 2), 2).ToString + " CHF", MsgBoxStyle.Information)
    End Sub

    'Gestion de la disponibilité du bouton "Supprimer"
    Private Sub GererbtnSupprimerLocation()
        btnSupprimerLocation.Enabled = dgvListeLoca.Rows.Count <> 0
    End Sub

    'Gestion de la disponibilité du bouton "Retour location"
    Private Sub GererbtnRetourLocation()
        btnRetourLocation.Enabled = dgvListeLoca.Rows.Count <> 0 And dgvListeLoca.CurrentRow.Cells.Item(2).Value < Date.Now
    End Sub

    '----------------------------------------------------------------
    ' ONGLET CLIENT TabClient
    '----------------------------------------------------------------
    'Réaffichage de l'onglet
    Public Sub RefreshTabClient()
        tbRecherche.Text = "Recherche"
        SelectAllTbRecherche()

        AfficherListeClient()
        AfficherDetailClient()
        AfficherMatLocaClient()

        GererBtnSupprimerClient()
        GererBtnModifierClient()
        tbRecherche.Focus()
    End Sub

    'Affiche la liste des clients dans dgvListeClient
    Private Sub AfficherListeClient()
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader
        Dim uneLigne(7) As String

        dgvListeClient.Focus()
        strRequete = "SELECT pers_no, pers_nom, pers_prenom, pers_tel, pers_adresse, pers_mail, pers_isAdmin FROM vw_persMod WHERE pers_isArchive = 0 ORDER BY pers_nom, pers_prenom"
        do_sql(strRequete, reader_Sql)
        dgvListeClient.Rows.Clear()
        While (reader_Sql.Read)
            uneLigne(0) = reader_Sql.Item(0).ToString 'pers_no
            uneLigne(1) = reader_Sql.Item(1).ToString 'pers_nom
            uneLigne(2) = reader_Sql.Item(2).ToString 'pers_prenom
            uneLigne(3) = reader_Sql.Item(3).ToString 'pers_tel
            uneLigne(4) = reader_Sql.Item(4).ToString 'pers_adresse
            uneLigne(5) = reader_Sql.Item(5).ToString 'pers_mail
            uneLigne(6) = reader_Sql.Item(6).ToString 'pers_isAdmin
            dgvListeClient.Rows.Add(uneLigne)
        End While
        If dgvListeClient.Rows.Count <> 0 Then
            dgvListeClient.Rows(0).Selected = True
        End If
    End Sub

    'Affiche le détail des informations du le client sélectionné
    Private Sub AfficherDetailClient()
        If dgvListeClient.Rows.Count <> 0 Then
            tbNoClientClient.Text = dgvListeClient.CurrentRow.Cells.Item(0).Value.ToString
            tbNomClient.Text = dgvListeClient.CurrentRow.Cells.Item(1).Value
            tbPrenomClient.Text = dgvListeClient.CurrentRow.Cells.Item(2).Value
            tbTelephoneClient.Text = dgvListeClient.CurrentRow.Cells.Item(3).Value
            tbAdresseClient.Text = dgvListeClient.CurrentRow.Cells.Item(4).Value
            tbMailClient.Text = dgvListeClient.CurrentRow.Cells.Item(5).Value
            cbIsAdmin.Checked = (dgvListeClient.CurrentRow.Cells.Item(6).Value = 1)
            mtbPwdClient.Text = ""
        End If
    End Sub

    'Affiche la liste du matériel loué par le client dans dgvMatLocaClient
    Private Sub AfficherMatLocaClient()
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader
        Dim uneLigne(4) As String

        If tbNoClientClient.Text.Length <> 0 Then
            dgvMatLocaClient.Focus()
            strRequete = "SELECT stock_no, stock_type, stock_marque, stock_taille FROM vw_matClient WHERE loca_pers_no = " + tbNoClientClient.Text
            do_sql(strRequete, reader_Sql)
            dgvMatLocaClient.Rows.Clear()
            While (reader_Sql.Read)
                uneLigne(0) = reader_Sql.Item(0) 'stock_no
                uneLigne(1) = reader_Sql.Item(1) 'stock_type
                uneLigne(2) = reader_Sql.Item(2) 'stock_marque
                uneLigne(3) = reader_Sql.Item(3) 'stock_taille
                dgvMatLocaClient.Rows.Add(uneLigne)
            End While
            If dgvMatLocaClient.Rows.Count <> 0 Then
                dgvMatLocaClient.Rows(0).Selected = True
            End If
        End If

    End Sub

    'Recherche le client dans dgvListeClient contenant dans son nom ou prénom le champ de recherche (tbRecherche)
    Private Sub RechercheClient()
        If dgvListeClient.Rows.Count <> 0 Then
            For i As Integer = 0 To dgvListeClient.Rows.Count - 1
                With dgvListeClient.Rows.Item(i)
                    .Visible = .Cells.Item(1).Value.ToString.ToLower.Contains(tbRecherche.Text.ToLower) Or .Cells.Item(2).Value.ToString.ToLower.Contains(tbRecherche.Text.ToLower)
                End With
            Next
        End If
    End Sub

    'Sélectionne tout le texte se trouvant dans TbRecherche, garde la sélection même en perdant le focus et focus sur TbRecherche
    Private Sub SelectAllTbRecherche()
        tbRecherche.SelectionStart = 0
        tbRecherche.SelectionLength = tbRecherche.Text.Length
        tbRecherche.HideSelection = False
    End Sub

    'Supprime (archive) le client actuellement sélectionné
    Private Sub SupprimerClient()
        Dim reader_Sql As OracleDataReader
        Dim strRequete As String

        strRequete = "SELECT pers_isAdmin FROM vw_persMod WHERE pers_no = " + dgvListeClient.CurrentRow.Cells.Item(0).Value.ToString
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        'Ne l'effacer que si ce N'est PAS un admin (1)
        If Not reader_Sql.Item(0) = 1 Then
            strRequete = "UPDATE vw_persMod SET pers_isArchive = 1 WHERE pers_no = " + dgvListeClient.CurrentRow.Cells.Item(0).Value.ToString
            do_sql(strRequete, reader_Sql)
            MsgBox("Le client a été supprimé.", MsgBoxStyle.Information)

            RefreshTabClient()
        End If
    End Sub

    'Modifie le client actuellement affiché
    Private Sub ModifierClient()
        Dim reader_Sql As OracleDataReader
        Dim strRequete As String

        If ChampsClientValide() Then
            Dim isAdmin As Integer = 0
            If cbIsAdmin.Checked = True Then
                isAdmin = 1
            End If
            'modification des infos de base
            strRequete = "UPDATE vw_persMod SET pers_nom = '" + tbNomClient.Text + "', pers_prenom = '" + tbPrenomClient.Text + "', pers_tel = '" + tbTelephoneClient.Text + "', pers_adresse = '" + tbAdresseClient.Text + "', pers_mail = '" + tbMailClient.Text + "', pers_isAdmin = " + isAdmin.ToString + " WHERE pers_no = " + tbNoClientClient.Text
            do_sql(strRequete, reader_Sql)

            'Si le password n'est pas vide
            If mtbPwdClient.Text.Length <> 0 Then
                If PwdExist() Then
                    'S'il existe, l'encoder en MD5 et le mettre à jour
                    Dim HashCode As Md5Hash
                    HashCode = New Md5Hash()
                    'MessageBox.Show(HashCode.Md5FromString(mtbPwdClient.ToString), "Md5", MessageBoxButtons.OK, MessageBoxIcon.Information)   'Msg test
                    strRequete = "UPDATE vw_pwd SET pwd_md5 = '" + HashCode.Md5FromString(mtbPwdClient.ToString) + "' WHERE pwd_pers_no = " + tbNoClientClient.Text
                Else
                    'S'il n'existe pas, l'encoder en MD5 et créer une nouvelle ligne dans bm_pwd
                    Dim HashCode As Md5Hash
                    HashCode = New Md5Hash()
                    'MessageBox.Show(HashCode.Md5FromString(mtbPwdClient.ToString), "Md5", MessageBoxButtons.OK, MessageBoxIcon.Information)   'Msg test
                    strRequete = "INSERT INTO vw_pwd VALUES(" + tbNoClientClient.Text + ",'" + HashCode.Md5FromString(mtbPwdClient.Text) + "')"
                End If
                do_sql(strRequete, reader_Sql)
            End If
            RefreshTabClient()
        End If

    End Sub

    'Test si le client affiché a déjà un password ou non
    Private Function PwdExist() As Boolean
        Dim reader_Sql As OracleDataReader
        Dim strRequete As String

        strRequete = "SELECT count(pwd_pers_no) FROM vw_pwd WHERE pwd_pers_no = " + tbNoClientClient.Text
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()

        Return (reader_Sql.Item(0) <> 0)

    End Function

    'Fonction qui teste si les champs nom, prénom et téléphone sont valides (non-vide et pas trop long)
    'les autres champs 
    Private Function ChampsClientValide() As Boolean
        If tbNoClientClient.Text = "" Then
            Return False
        End If

        If tbNomClient.Text = "" Or tbNomClient.Text.Length > 30 Then
            Return False
        End If

        If tbPrenomClient.Text = "" Or tbPrenomClient.Text.Length > 30 Then
            Return False
        End If

        If tbTelephoneClient.Text = "" Or tbTelephoneClient.Text.Length > 20 Or Not (IsNumeric(tbTelephoneClient.Text)) Then
            Return False
        End If

        If tbAdresseClient.Text.Length > 50 Then
            Return False
        End If

        If tbMailClient.Text.Length > 30 Then
            Return False
        End If

        Return True
    End Function

    'Empêche de désélectionner CbIsAdmin (ne plus être admin) quand il ne reste plus que 1 admin
    Private Sub GererEtatCbIsAdmin()
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader

        'Nb de client qui sont admin (isAdmin = 1)
        strRequete = "SELECT count(pers_no) FROM vw_persMod WHERE pers_isAdmin = 1"
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        'S'il n'y a qu'un seul admin et que la personne sélectionné est admin
        If reader_Sql.Item(0) = 1 And dgvListeClient.CurrentRow.Cells.Item(6).Value = 1 Then
            'la case reste cochée
            cbIsAdmin.Checked = True
        End If
    End Sub

    'gestion de la disponibilité du bouton "Modifier" client
    Private Sub GererBtnModifierClient()
        btnModifierClient.Enabled = ChampsClientValide()
    End Sub

    'gestion de la disponibilité du bouton "Supprimer" client
    Private Sub GererBtnSupprimerClient()
        btnSupprimerClient.Enabled = dgvListeClient.Rows.Count <> 0
    End Sub

    '----------------------------------------------------------------
    ' ONGLET MATERIEL TabMateriel
    '----------------------------------------------------------------
    'Réaffichage de l'onglet
    Public Sub RefreshTabMateriel()
        AfficherListeMateriel()
        AfficherDetailMat()
        GererBtnModifierMat()
        GererBtnSupprimerMat()
    End Sub


    'Affiche la liste du matériel (le stock) dans dgvListeMateriel qui ne sont pas archivés (p.ex vendu ou détruit)
    Private Sub AfficherListeMateriel()
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader
        Dim uneLigne(4) As String

        dgvListeMateriel.Focus()
        strRequete = "SELECT stock_no, stock_type, stock_marque, stock_taille FROM vw_stock"
        do_sql(strRequete, reader_Sql)
        dgvListeMateriel.Rows.Clear()
        While (reader_Sql.Read)
            uneLigne(0) = reader_Sql.Item(0) 'stock_no
            uneLigne(1) = reader_Sql.Item(1) 'stock_type
            uneLigne(2) = reader_Sql.Item(2) 'stock_marque
            uneLigne(3) = reader_Sql.Item(3) 'stock_taille
            dgvListeMateriel.Rows.Add(uneLigne)
        End While
        If dgvListeMateriel.Rows.Count <> 0 Then
            dgvListeMateriel.Rows.Item(0).Selected = True
        End If
    End Sub

    'Affiche le détail du matériel sélectionné
    Private Sub AfficherDetailMat()
        If dgvListeMateriel.Rows.Count <> 0 Then
            tbNoMat.Text = dgvListeMateriel.CurrentRow.Cells.Item(0).Value.ToString         'stock_no
            Select Case dgvListeMateriel.CurrentRow.Cells.Item(1).Value.ToString.ToLower    'stock_type
                Case "paddle"
                    cbbTypeMat.SelectedIndex = 0
                Case "planche"
                    cbbTypeMat.SelectedIndex = 1
                Case "voile"
                    cbbTypeMat.SelectedIndex = 2
            End Select
            tbMarqueMat.Text = dgvListeMateriel.CurrentRow.Cells.Item(2).Value.ToString     'stock_marque
            tbTailleMat.Text = dgvListeMateriel.CurrentRow.Cells.Item(3).Value.ToString     'stock_taille
            Dim reader_Sql As OracleDataReader
            Dim strRequete As String
            'On cherche le nombre de location avec ce matériel qui ont déjà commencé et qui ne sont pas encore archivé (retour location)
            strRequete = "SELECT count(*) FROM vw_stockLoca  WHERE stock_no = " + dgvListeMateriel.CurrentRow.Cells.Item(0).Value + " AND loca_heureDebut < SYSDATE AND loca_isArchive = 0"
            do_sql(strRequete, reader_Sql)
            reader_Sql.Read()
            cbEnLocationMat.Checked = (reader_Sql.Item(0) > 0) 'En Location ?
        End If


    End Sub

    'Supprime (archive) le matériel actuellement sélectionné
    Private Sub SupprimerMateriel()
        Dim reader_Sql As OracleDataReader
        Dim strRequete As String

        strRequete = "UPDATE vw_stockMod SET stock_isArchive = 1 WHERE stock_no = " + dgvListeMateriel.CurrentRow.Cells.Item(0).Value
        do_sql(strRequete, reader_Sql)

        cbbTypeMat.SelectedIndex = -1
        tbNoMat.Text = ""
        tbMarqueMat.Text = ""
        tbTailleMat.Text = ""
        cbEnLocationMat.Checked = False

        RefreshTabMateriel()
    End Sub

    'Modifie le matériel actuellement affiché
    Private Sub ModifierMateriel()
        Dim reader_Sql As OracleDataReader
        Dim strRequete As String

        If ChampsMaterielValide() Then
            strRequete = "UPDATE vw_stockMod SET stock_type = '" + cbbTypeMat.Text.ToLower + "', stock_marque = '" + tbMarqueMat.Text + "', stock_taille = '" + tbTailleMat.Text.Trim + "' WHERE stock_no = " + tbNoMat.Text
            do_sql(strRequete, reader_Sql)
        End If

        RefreshTabMateriel()
    End Sub

    'Fonction qui teste si les champs marque, taille et no  sont valides (non-vide ou pas trop long et pour la taille numérique)
    ' et qu'un type est sélectionné
    Private Function ChampsMaterielValide() As Boolean

        If tbMarqueMat.Text = "" Or tbMarqueMat.Text.Length > 30 Then
            Return False
        End If

        If tbTailleMat.Text = "" Or tbTailleMat.Text.Length > 3 Or Not (IsNumeric(tbTailleMat.Text)) Then
            Return False
        End If

        If tbNoMat.Text.Length = 0 Then
            Return False
        End If

        If cbbTypeMat.SelectedIndex = -1 Then
            Return False
        End If

        Return True
    End Function

    Private Sub GererBtnSupprimerMat()
        btnSupprimerMat.Enabled = dgvListeMateriel.Rows.Count <> 0
    End Sub

    Private Sub GererBtnModifierMat()
        btnModifierMat.Enabled = ChampsMaterielValide()
    End Sub

    '----------------------------------------------------------------
    ' ONGLET ARCHIVES TabArchives
    '----------------------------------------------------------------
    'Réaffichage de l'onglet
    Private Sub RefreshTabArchives()
        AfficherLocaArchive()
        AfficherMatArchive()
        AfficherClientArchive()
        GérerBtnRestauClient()
    End Sub

    'Affiche les locations archivées
    Private Sub AfficherLocaArchive()
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader
        Dim uneLigne(4) As String

        dgvLocaArchive.Focus()
        strRequete = "SELECT loca_no, pers_prenom, loca_heureDebut, loca_heureFin FROM vw_locaClient WHERE loca_isArchive = 1 ORDER BY loca_heureFin DESC"
        do_sql(strRequete, reader_Sql)
        dgvLocaArchive.Rows.Clear()
        While (reader_Sql.Read)
            uneLigne(0) = reader_Sql.Item(0).ToString                    'loca_no
            uneLigne(1) = reader_Sql.Item(1).ToString                    'pers_prenom
            uneLigne(2) = Format(reader_Sql.Item(2), "dd.MM.yyyy HH:mm") 'loca_heureDebut
            uneLigne(3) = Format(reader_Sql.Item(3), "dd.MM.yyyy HH:mm") 'loca_heureFin
            dgvLocaArchive.Rows.Add(uneLigne)
        End While
        If dgvLocaArchive.Rows.Count <> 0 Then
            dgvLocaArchive.Rows.Item(0).Selected = True
        End If
    End Sub

    'Affiche le matériel archivé
    Private Sub AfficherMatArchive()
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader
        Dim uneLigne(4) As String

        dgvMatArchive.Focus()
        strRequete = "SELECT stock_no, stock_type, stock_marque, stock_taille FROM vw_stockMod WHERE stock_isArchive = 1 ORDER BY stock_no"
        do_sql(strRequete, reader_Sql)
        dgvMatArchive.Rows.Clear()
        While (reader_Sql.Read)
            uneLigne(0) = reader_Sql.Item(0).ToString 'stock_no
            uneLigne(1) = reader_Sql.Item(1).ToString 'stock_type
            uneLigne(2) = reader_Sql.Item(2).ToString 'stock_marque
            uneLigne(3) = reader_Sql.Item(3).ToString 'stock_taille
            dgvMatArchive.Rows.Add(uneLigne)
        End While
        If dgvMatArchive.Rows.Count <> 0 Then
            dgvMatArchive.Rows.Item(0).Selected = True
        End If
    End Sub

    'Affiche les clients archives
    Private Sub AfficherClientArchive()
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader
        Dim uneLigne(6) As String

        dgvClientArchive.Focus()
        strRequete = "SELECT pers_no, pers_nom, pers_prenom, pers_tel, pers_mail, pers_adresse  FROM vw_persMod WHERE pers_isArchive = 1 ORDER BY pers_nom, pers_prenom"
        do_sql(strRequete, reader_Sql)
        dgvClientArchive.Rows.Clear()
        While (reader_Sql.Read)
            uneLigne(0) = reader_Sql.Item(0).ToString 'pers_no
            uneLigne(1) = reader_Sql.Item(1).ToString 'pers_nom
            uneLigne(2) = reader_Sql.Item(2).ToString 'pers_prenom
            uneLigne(3) = reader_Sql.Item(3).ToString 'pers_tel
            uneLigne(4) = reader_Sql.Item(4).ToString 'pers_mail
            uneLigne(5) = reader_Sql.Item(5).ToString 'pers_adresse
            dgvClientArchive.Rows.Add(uneLigne)
        End While
        If dgvClientArchive.Rows.Count <> 0 Then
            dgvClientArchive.Rows(0).Selected = True
        End If
    End Sub

    'Restaure le client archivé sélectionné (pers_isArchive = 0)
    Private Sub RestaurerClient()
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader

        strRequete = "UPDATE vw_persMod SET pers_isArchive = 0 WHERE pers_no = " + dgvClientArchive.CurrentRow.Cells.Item(0).Value.ToString
        do_sql(strRequete, reader_Sql)

        RefreshTabArchives()
    End Sub

    Private Sub GérerBtnRestauClient()
        btnRestauClient.Enabled = dgvClientArchive.Rows.Count <> 0
    End Sub

    '----------------------------------------------------------------
    ' ONGLET STATISTIQUES TabStat
    '----------------------------------------------------------------
    'Affiche les stats actuelles
    Private Sub RefreshTabStats()
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader

        'Nb de client
        strRequete = "SELECT count(pers_no) FROM vw_pers"
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()

        lblNbClientValue.Text = reader_Sql.Item(0).ToString



        'Nb de paddle occupé maintenant (dont la location a commencé mais n'est pas encore archivé (retour location))
        'strRequete = "SELECT count(stock_no) FROM vw_stockLoca WHERE stock_type = 'paddle' AND loca_isArchive = 0 AND loca_heureDebut < to_date('" + Format(DateAndTime.Now, "dd.MM.yyyy HH:mm") + "','dd.mm.yyyy hh24:mi')"
        strRequete = "SELECT count(stock_no) FROM vw_stockLoca WHERE stock_type = 'paddle' AND loca_isArchive = 0 AND loca_heureDebut < SYSDATE"
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        Dim nbPadoccupe As Integer = reader_Sql.Item(0)

        'Nb de paddle total
        strRequete = "SELECT count(stock_no) FROM vw_stock WHERE stock_type = 'paddle'"
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        Dim nbPadTot As Integer = reader_Sql.Item(0)

        'Nb de paddle libre
        Dim nbPadLibre As Integer = nbPadTot - nbPadoccupe
        Dim p100Paddle As Double
        If nbPadTot = 0 Then
            p100Paddle = 0
        Else
            p100Paddle = nbPadLibre / nbPadTot * 100
        End If

        lblNbPadValue.Text = nbPadLibre.ToString + "  sur  " + nbPadTot.ToString + "   (" + Math.Round(p100Paddle, 2).ToString + " %)"



        'Nb de planche occupé maintenant
        'strRequete = "SELECT count(stock_no) FROM vw_stockLoca WHERE stock_type = 'planche' AND loca_isArchive = 0 AND loca_heureDebut < to_date('" + Format(DateAndTime.Now, "dd.MM.yyyy HH:mm") + "','dd.mm.yyyy hh24:mi')"
        strRequete = "SELECT count(stock_no) FROM vw_stockLoca WHERE stock_type = 'planche' AND loca_isArchive = 0 AND loca_heureDebut < SYSDATE"
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        Dim nbPlancheOccupe As Integer = reader_Sql.Item(0)

        'Nb de planche total
        strRequete = "SELECT count(stock_no) FROM vw_stock WHERE stock_type = 'planche'"
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        Dim nbPlancheTot As Integer = reader_Sql.Item(0)

        'Nb de planche libre
        Dim nbPlancheLibre As Integer = nbPlancheTot - nbPlancheOccupe


        'Nb de voile occupée
        'strRequete = "SELECT count(stock_no) FROM vw_stockLoca WHERE stock_type = 'voile' AND loca_isArchive = 0 AND loca_heureDebut < to_date('" + Format(DateAndTime.Now, "dd.MM.yyyy HH:mm") + "','dd.mm.yyyy hh24:mi')"
        strRequete = "SELECT count(stock_no) FROM vw_stockLoca WHERE stock_type = 'voile' AND loca_isArchive = 0 AND loca_heureDebut < SYSDATE"
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        Dim nbVoileOccupe As Integer = reader_Sql.Item(0)

        'Nb de voile total
        strRequete = "SELECT count(stock_no) FROM vw_stock WHERE stock_type = 'voile'"
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        Dim nbVoileTot As Integer = reader_Sql.Item(0)

        'Nb de planche libre
        Dim nbVoileLibre As Integer = nbVoileTot - nbVoileOccupe

        'Nb de planche à voile total (planche + voile) : le plus petit
        Dim min As Integer
        Dim nbPVtot As Integer
        If nbPlancheLibre > nbVoileLibre Then
            min = nbVoileLibre
            nbPVtot = nbVoileTot
        Else
            min = nbPlancheLibre
            nbPVtot = nbPlancheTot
        End If

        Dim p100PV As Double
        If nbPVtot = 0 Then
            p100PV = 0
        Else
            p100PV = min / nbPVtot * 100
        End If
        lblNbPVValue.Text = min.ToString + "  sur  " + nbPVtot.ToString + "   (" + Math.Round(p100PV, 2).ToString + " %)"



        'nb de location active
        strRequete = "SELECT count(loca_no) FROM vw_locaClient WHERE loca_heureDebut < SYSDATE AND loca_isArchive = 0"
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        Dim nbLocaActive As Integer = reader_Sql.Item(0)
        lblNbLocaActiveValue.Text = nbLocaActive.ToString

        'nb de location aujourd'hui
        strRequete = "SELECT count(loca_no) FROM vw_locaClient WHERE to_char(loca_heureDebut, 'DD MM YYYY') = to_char(SYSDATE, 'DD MM YYYY')"
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        Dim nbLocaJour As Integer = reader_Sql.Item(0)
        lblNbLocaJourValue.Text = nbLocaJour.ToString + "   (Moyenne : " + Math.Round(nbLocaJour / 24, 2).ToString + " / heure)"

        'Nb de location ce mois-ci
        strRequete = "SELECT count(loca_no) FROM vw_locaClient WHERE to_char(loca_heureDebut, 'MM YYYY') = to_char(SYSDATE, 'MM YYYY')"
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        Dim nbLocaMois As Integer = reader_Sql.Item(0)
        lblNbLocaMoisValue.Text = nbLocaMois.ToString + "   (Moyenne : " + Math.Round(nbLocaMois / 30, 2).ToString + " / jour)"

        'Nb de location cette saison
        strRequete = "SELECT count(loca_no) FROM vw_locaClient WHERE to_char(loca_heureDebut, 'YYYY') = to_char(SYSDATE, 'YYYY')"
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        Dim nbLocaSaison As Integer = reader_Sql.Item(0)
        lblNbLocaSaisonValue.Text = nbLocaSaison.ToString

    End Sub

    '----------------------------------------------------------------
    ' ONGLET ABOUT TabAbout
    '----------------------------------------------------------------

    'Merci d'avoir lu le code jusqu'ici. :D

End Class