﻿Imports BookMe.ModBDD
Imports Oracle.DataAccess.Client

Public Class frmlogin

    Dim persNo As Integer = -1

    '===========================
    '=      EVENEMENTS         =
    '===========================

    Private Sub frmlogin_Load(sender As Object, e As EventArgs) Handles MyBase.Load

        'positionnement à l'ouverture juste en dessus du SplashScreen
        Dim workingArea As Rectangle = System.Windows.Forms.Screen.GetWorkingArea(New Point(0, 0))
        Dim x As Integer = workingArea.Width / 2 - Me.Width / 2
        Dim y As Integer = workingArea.Height / 2 - Me.Height - frmSplashScreen.Height / 2 - 5
        Me.Location = New Point(x, y)

        Me.tb_usr.Focus()
        gererBtnOK()
    End Sub

    Private Sub btn_OK_Click(sender As Object, e As EventArgs) Handles btn_OK.Click

        persNo = WhoIs()
        If persNo <> -1 Then
            If CheckPwd() Then
                Me.DialogResult = Windows.Forms.DialogResult.OK
                frmMain.SetIsAdmin(isAdmin())
                frmMain.Enabled = True
                Me.Close()
            Else
                ErreurAuth()
                gererBtnOK()
            End If
        Else
            ErreurAuth()
            gererBtnOK()
        End If
    End Sub

    Private Sub btn_annuler_Click(sender As Object, e As EventArgs) Handles btn_annuler.Click
        Me.Close()
        frmMain.Close()
    End Sub

    Private Sub tb_usr_TextChanged(sender As Object, e As EventArgs) Handles tb_usr.TextChanged
        gererBtnOK()
    End Sub

    Private Sub mtb_pwd_TextChanged(sender As Object, e As EventArgs) Handles mtb_pwd.TextChanged
        gererBtnOK()
    End Sub

    '===========================
    '= PROCEDURES ET FONCTIONS =
    '===========================

    'Signale l'erreure par une MsgBox et réinitialise le mdp (qui est le plus souvent la composante fausse)
    Private Sub ErreurAuth()
        MsgBox("Nom d'utilisateur ou mot de passe incorrect.", MsgBoxStyle.Exclamation)
        mtb_pwd.Text = ""
        mtb_pwd.Focus()
    End Sub

    'Retour si la personne persNo (qui se logue) est admin ou non
    Private Function isAdmin() As Boolean
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader

        strRequete = "SELECT pers_isAdmin from vw_persMod WHERE pers_no = " + persNo.ToString
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        If reader_Sql.Item(0) = 1 Then
            Return True
        End If
        Return False
    End Function

    'Indique si la personne (nom, prenom) existe une et une seule fois dans bm_pers
    Private Function ExistPers(ByVal nom As String, ByVal prenom As String) As Boolean
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader

        strRequete = "SELECT count(*) FROM vw_pers WHERE lower(pers_nom) = '" + nom + "' AND lower(pers_prenom) = '" + prenom + "'"
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        If reader_Sql.Item(0) <> 1 Then
            Return False
        End If
        Return True
    End Function

    'Retourne l'index de l'utilisateur
    ' + Retourn -1 s'il n'en a pas trouvé ou s'il existe plusieurs occurences avec ce nom et prénom
    Private Function WhoIs() As Integer
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader
        Dim usr As String = tb_usr.Text
        Dim posSepa As Integer = usr.IndexOf(".")

        If posSepa <> -1 Then
            Dim prenom As String = usr.Substring(0, posSepa).ToLower
            Dim nom As String = usr.Substring(posSepa + 1, usr.Length - posSepa - 1).ToLower
            If ExistPers(nom, prenom) Then
                strRequete = "SELECT pers_no from vw_pers WHERE lower(pers_nom) = '" + nom + "' AND lower(pers_prenom) = '" + prenom + "'"
                do_sql(strRequete, reader_Sql)
                reader_Sql.Read()
                Return reader_Sql.Item(0)
            End If
        End If
        Return -1
    End Function

    'Vérifie si les mots de passe concordent en Md5
    Private Function CheckPwd() As Boolean
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader

        'On regarde si la personne a une entrée dans la table de password correspondant à son persNo
        strRequete = "SELECT count(*) from vw_pwd WHERE pwd_pers_no = " + persNo.ToString
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        'Si c'est le cas, on va comparer les mots de passe encodé en Md5
        If Not reader_Sql.Item(0) = 0 Then
            'on récupère le password de la BDD qui est haché en Md5
            strRequete = "SELECT pwd_md5 from vw_pwd WHERE pwd_pers_no = " + persNo.ToString
            do_sql(strRequete, reader_Sql)
            reader_Sql.Read()
            Dim pwdMd5 As String = reader_Sql.Item(0).ToString
            'on le compare au mot de passe entré par l'utilisateur haché en Md5 aussi
            Dim HashCode As Md5Hash
            HashCode = New Md5Hash()
            'MessageBox.Show(HashCode.Md5FromString(mtb_pwd.ToString), "Md5", MessageBoxButtons.OK, MessageBoxIcon.Information)
            If pwdMd5.CompareTo(HashCode.Md5FromString(mtb_pwd.ToString)) = 0 Then
                Return True
            End If
        End If
        Return False
    End Function

    'Gère la disponibilité du bouton "OK"
    Private Sub gererBtnOK()
        btn_OK.Enabled = tb_usr.Text.Length <> 0 And mtb_pwd.Text.Length <> 0
    End Sub

End Class