﻿Imports BookMe.ModBDD
Imports Oracle.DataAccess.Client

Public Class frm_nouveauClient

    '===========================
    '=      EVENEMENTS         =
    '===========================

    Private Sub tbNom_TextChanged(sender As Object, e As EventArgs) Handles tbNom.TextChanged
        GererBtnEnregistrer()
    End Sub

    Private Sub tbPrenom_TextChanged(sender As Object, e As EventArgs) Handles tbPrenom.TextChanged
        GererBtnEnregistrer()
    End Sub

    Private Sub tbTelephone_TextChanged(sender As Object, e As EventArgs) Handles tbTelephone.TextChanged
        GererBtnEnregistrer()
    End Sub

    Private Sub frm_nouveauClient_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        btnEnregistrer.Enabled = False
    End Sub

    Private Sub btnAnnuler_Click(sender As Object, e As EventArgs) Handles btnAnnuler.Click
        Me.Close()
    End Sub

    Private Sub btnEnregistrer_Click(sender As Object, e As EventArgs) Handles btnEnregistrer.Click
        If ExistClient() Then
            MsgBox("Ce client existe déjà.", MsgBoxStyle.Information)
        Else
            AjouterClient()
            MsgBox("Le client a été ajouté.", MsgBoxStyle.Information)
            Me.Close()
        End If

    End Sub

    Private Sub frm_nouveauClient_FormClosing(sender As Object, e As FormClosingEventArgs) Handles Me.FormClosing
        frmMain.Enabled = True
    End Sub

    '===========================
    '= PROCEDURES ET FONCTIONS =
    '===========================

    'Insert un client dans bm_pers avec les détails correspondant
    Private Sub AjouterClient()
        Dim reader_Sql As OracleDataReader
        Dim strRequete As String

        strRequete = "INSERT INTO vw_persMod VALUES ('','" + tbNom.Text + "','" + tbPrenom.Text + "','" + tbTelephone.Text + "','" + tbAdresse.Text + "','" + tbMail.Text + "', 0)"
        do_sql(strRequete, reader_Sql)
        frmMain.RefreshTabClient()
    End Sub

    'Fonction qui teste si les champs nom, prénom, téléphone adresse et mail sont valides (non-vide ou pas trop long ou numéric)
    Private Function ChampsClientValide() As Boolean
        If tbNom.Text = "" Or tbNom.Text.Length > 30 Then
            Return False
        End If

        If tbPrenom.Text = "" Or tbPrenom.Text.Length > 30 Then
            Return False
        End If

        If tbTelephone.Text = "" Or tbTelephone.Text.Length > 20 Or Not (IsNumeric(tbTelephone.Text)) Then
            Return False
        End If

        If tbAdresse.Text.Length > 50 Then
            Return False
        End If

        If tbMail.Text.Length > 30 Then
            Return False
        End If

        Return True
    End Function

    'Fonction pour savoir si le client (nom et prenom) existe déjà dans bm_pers
    'Ce couple doit être différent -> login : prenom.nom
    Private Function ExistClient() As Boolean
        Dim reader_Sql As OracleDataReader
        Dim strRequete As String

        strRequete = "SELECT COUNT(*) FROM vw_pers WHERE lower(pers_nom) = '" + tbNom.Text.ToLower + "' AND lower(pers_prenom) = '" + tbPrenom.Text.ToLower + "'"
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        If reader_Sql.Item(0) = 0 Then
            Return False
        Else
            Return True
        End If
    End Function

    'Gère la disponibilité du bouton "Enregistrer"
    Private Sub GererBtnEnregistrer()
        btnEnregistrer.Enabled = ChampsClientValide()
    End Sub

End Class