﻿Imports BookMe.ModBDD
Imports Oracle.DataAccess.Client

Public Class frm_nouvelleLocation

    Dim grpPV As Integer

    '===========================
    '=      EVENEMENTS         =
    '===========================

    Private Sub frm_nouvelleLocation_Load(sender As Object, e As EventArgs) Handles MyBase.Load

        grpPV = 0
        dtpDebut.MinDate = DateAndTime.Now

        RefreshListesMat()
        AfficherListeClient()

        GererBtnSupprimer()
        GererBtnAjouterPad()
        gererBtnAjouterPV()
        GererBtnLouer()

        SelectAllTbRecherche()
        tbRecherche.Focus()
    End Sub

    Private Sub btnAjouterPad_Click(sender As Object, e As EventArgs) Handles btnAjouterPad.Click
        AjouterPaddle()
        GererBtnSupprimer()
        GererBtnAjouterPad()
        GererBtnLouer()
    End Sub

    Private Sub btnAjouterPV_Click(sender As Object, e As EventArgs) Handles btnAjouterPV.Click
        AjouterPlancheVoile()
        GererBtnSupprimer()
        gererBtnAjouterPV()
        GererBtnLouer()
    End Sub

    Private Sub btnSupprimer_Click(sender As Object, e As EventArgs) Handles btnSupprimer.Click
        'supprime le matériel (la ligne) sélectionné dans dgvMatLouer
        SupprimerMaterielListe()
        GererBtnSupprimer()
        GererBtnAjouterPad()
        gererBtnAjouterPV()
        GererBtnLouer()
        'MsgBox("Le matériel a été retiré de la liste.", MsgBoxStyle.Information)
    End Sub

    Private Sub btnAnnuler_Click(sender As Object, e As EventArgs) Handles btnAnnuler.Click
        Me.Close()
    End Sub

    Private Sub btnLouer_Click(sender As Object, e As EventArgs) Handles btnLouer.Click
        LouerMat()
        MsgBox("La location a été enregistrée.", MsgBoxStyle.Information)
        Me.Close()
    End Sub

    Private Sub dgvPlancheDispo_CellClick(sender As Object, e As DataGridViewCellEventArgs) Handles dgvPlancheDispo.CellClick
        gererBtnAjouterPV()
    End Sub

    Private Sub dgvVoileDispo_CellClick(sender As Object, e As DataGridViewCellEventArgs) Handles dgvVoileDispo.CellClick
        gererBtnAjouterPV()
    End Sub

    Private Sub dgvClient_CellClick(sender As Object, e As DataGridViewCellEventArgs) Handles dgvClient.CellClick
        GererBtnLouer()
    End Sub

    Private Sub dtpDebut_ValueChanged(sender As Object, e As EventArgs) Handles dtpDebut.ValueChanged
        dgvMatLouer.Rows.Clear()
        RefreshListesMat()
        GererBtnSupprimer()
        GererBtnAjouterPad()
        gererBtnAjouterPV()
        GererBtnLouer()
    End Sub

    Private Sub nudDuree_ValueChanged(sender As Object, e As EventArgs) Handles nudDuree.ValueChanged
        dgvMatLouer.Rows.Clear()
        RefreshListesMat()
        GererBtnSupprimer()
        GererBtnAjouterPad()
        gererBtnAjouterPV()
        GererBtnLouer()
    End Sub

    Private Sub tbRecherche_Click(sender As Object, e As EventArgs) Handles tbRecherche.Click
        If tbRecherche.Text = "Recherche" Then
            SelectAllTbRecherche()
        End If
    End Sub

    'A la perte du focus de tbRecherche
    Private Sub tbRecherche_LostFocus(sender As Object, e As EventArgs) Handles tbRecherche.LostFocus
        If tbRecherche.Text.Length = 0 Then
            tbRecherche.Text = "Recherche"
            AfficherListeClient() 'on réaffiche tout car la modification du text en "Recherche" lance à nouveau la recherche
            SelectAllTbRecherche()
        End If
    End Sub

    Private Sub tbRecherche_TextChanged(sender As Object, e As EventArgs) Handles tbRecherche.TextChanged
        RechercheClient()
    End Sub

    Private Sub frm_nouvelleLocation_FormClosing(sender As Object, e As FormClosingEventArgs) Handles Me.FormClosing
        frmMain.Enabled = True
    End Sub

    '===========================
    '= PROCEDURES ET FONCTIONS =
    '===========================
    'Refresh les listes de matériel
    Private Sub RefreshListesMat()
        AfficherListe("paddle")
        AfficherListe("planche")
        AfficherListe("voile")

        MasquerLigneMatRes(dgvPadDispo)
        MasquerLigneMatRes(dgvPlancheDispo)
        MasquerLigneMatRes(dgvVoileDispo)

    End Sub

    'Affiche la liste du matériel disponible selon le type de liste passé en paramètre
    Private Sub AfficherListe(ByVal type As String)
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader
        Dim uneLigne(4) As String

        'il faut effacer le bon dgv
        Select Case type.ToLower
            Case "paddle"
                dgvPadDispo.Focus()
                dgvPadDispo.Rows.Clear()
            Case "planche"
                dgvPlancheDispo.Focus()
                dgvPlancheDispo.Rows.Clear()
            Case "voile"
                dgvVoileDispo.Focus()
                dgvVoileDispo.Rows.Clear()
            Case Else
                'il y a une erreure dans le type
        End Select
        'on selectionne le matériel disponible
        strRequete = "SELECT stock_no, stock_type, stock_marque, stock_taille FROM vw_stock WHERE stock_type = '" + type.ToLower + "'"
        do_sql(strRequete, reader_Sql)
        While (reader_Sql.Read)
            uneLigne(0) = reader_Sql.Item(0) 'stock_no
            uneLigne(1) = reader_Sql.Item(1) 'stock_type
            uneLigne(2) = reader_Sql.Item(2) 'stock_marque
            uneLigne(3) = reader_Sql.Item(3) 'stock_taille
            'on rajoute les infos dans la bonne dgv
            Select Case type.ToLower
                Case "paddle"
                    dgvPadDispo.Rows.Add(uneLigne)
                Case "planche"
                    dgvPlancheDispo.Rows.Add(uneLigne)
                Case "voile"
                    dgvVoileDispo.Rows.Add(uneLigne)
                Case Else
                    'il y a une erreure dans le type
            End Select
        End While

        'si la liste voulu n'est pas vide, sélectionner le 1er item
        Select Case type.ToLower
            Case "paddle"
                If dgvPadDispo.Rows.Count <> 0 Then
                    dgvPadDispo.Rows.Item(0).Selected = True
                End If
            Case "planche"
                If dgvPlancheDispo.Rows.Count <> 0 Then
                    dgvPlancheDispo.Rows.Item(0).Selected = True
                End If
            Case "voile"
                If dgvVoileDispo.Rows.Count <> 0 Then
                    dgvVoileDispo.Rows.Item(0).Selected = True
                End If
            Case Else
                'il y a une erreure dans le type
        End Select

    End Sub

    'Masquer les lignes de matériel dont la location chevauche la location en construction
    Private Sub MasquerLigneMatRes(dgvMat As DataGridView)
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader

        dgvMat.Focus()
        'Matériel à masquer :dont le début de la location est avant la fin de la location en construction ET qui n'est pas archivée, la fin avant le début de la location en cours ou que la location est déjà fini mais pas archivée
        strRequete = "SELECT UNIQUE stock_no FROM vw_stockLoca WHERE loca_heureDebut < to_date('" + Format(DateAdd("h", nudDuree.Value, dtpDebut.Value), "dd.MM.yyyy HH:mm") + "','dd.mm.yyyy hh24:mi') AND (loca_heureFin > to_date('" + Format(dtpDebut.Value, "dd.MM.yyyy HH:mm") + "','dd.mm.yyyy hh24:mi') OR loca_heureFin < SYSDATE AND loca_isArchive = 0)"
        do_sql(strRequete, reader_Sql)
        While (reader_Sql.Read)
            Dim stockNo As Integer = reader_Sql.Item(0) 'stock_no
            'on parcourt chaques ligne du dgvMat
            For Each row As DataGridViewRow In dgvMat.Rows
                If Not row.IsNewRow Then
                    'si le numéro de matériel à cette ligne = au numéro du matériel à masquer 
                    If row.Cells.Item(0).Value = stockNo Then
                        'on cache toute la ligne
                        row.Visible = False
                    End If
                End If
            Next
        End While

        'S'il y a un item visible
        If FirstSelectedVisible(dgvMat) <> -1 Then
            'on efface la sélection actuelle
            dgvMat.ClearSelection()
            'on sélectionne le 1er item visible
            dgvMat.Rows(FirstSelectedVisible(dgvMat)).Selected = True
        End If
    End Sub

    'Affiche la liste des clients dans dgvClient
    Private Sub AfficherListeClient()
        Dim strRequete As String
        Dim reader_Sql As OracleDataReader
        Dim uneLigne(3) As String

        dgvClient.Focus()
        strRequete = "SELECT pers_no, pers_nom, pers_prenom FROM vw_pers"
        do_sql(strRequete, reader_Sql)
        dgvClient.Rows.Clear()
        While (reader_Sql.Read)
            uneLigne(0) = reader_Sql.Item(0) 'pers_no
            uneLigne(1) = reader_Sql.Item(1) 'pers_nom
            uneLigne(2) = reader_Sql.Item(2) 'pers_prenom
            dgvClient.Rows.Add(uneLigne)
        End While
        'si la liste n'est pas vide, sélectionner le 1er item
        If dgvClient.Rows.Count <> 0 Then
            dgvClient.Rows.Item(0).Selected = True
        End If

    End Sub

    'Recherche le client dans dgvClient contenant dans son nom ou prénom le champ de recherche (tbRecherche)
    '(Ne garde visible que les lignes dont le camps de recherche est contenu dans le nom ou prénom)
    Private Sub RechercheClient()
        If dgvClient.Rows.Count <> 0 Then
            For i As Integer = 0 To dgvClient.Rows.Count - 1
                With dgvClient.Rows.Item(i)
                    .Visible = .Cells.Item(1).Value.ToString.ToLower.Contains(tbRecherche.Text.ToLower) Or .Cells.Item(2).Value.ToString.ToLower.Contains(tbRecherche.Text.ToLower)
                End With
            Next
        End If
    End Sub

    'Sélectionne tout le texte se trouvant dans TbRecherche
    Private Sub SelectAllTbRecherche()
        tbRecherche.SelectionStart = 0
        tbRecherche.SelectionLength = tbRecherche.Text.Length
        tbRecherche.HideSelection = False
        tbRecherche.Focus()
    End Sub

    'Ajoute à dgvMatLouer le paddle sélectionné dans dgvPadDispo et le retire de cette dernière
    Private Sub AjouterPaddle()
        Dim uneLigne(4) As String
        dgvPadDispo.Focus()
        uneLigne(0) = dgvPadDispo.CurrentRow.Cells.Item(0).Value 'stock_no
        uneLigne(1) = dgvPadDispo.CurrentRow.Cells.Item(1).Value 'stock_type
        uneLigne(2) = dgvPadDispo.CurrentRow.Cells.Item(2).Value 'stock_marque
        uneLigne(3) = dgvPadDispo.CurrentRow.Cells.Item(3).Value 'stock_taille
        dgvMatLouer.Rows.Add(uneLigne)
        dgvPadDispo.Rows.Remove(dgvPadDispo.CurrentRow)
    End Sub

    'Ajoute à dgvMatLouer la planche et la voile et les retirent de leur listes (dgvPlancheDispo et dgvVoileDispo)
    Private Sub AjouterPlancheVoile()
        Dim uneLigne(5) As String

        grpPV = grpPV + 1 'incrémentation du numéro de groupe planche à voile

        'Planche
        dgvPlancheDispo.Focus()
        uneLigne(0) = dgvPlancheDispo.CurrentRow.Cells.Item(0).Value 'no
        uneLigne(1) = dgvPlancheDispo.CurrentRow.Cells.Item(1).Value 'type
        uneLigne(2) = dgvPlancheDispo.CurrentRow.Cells.Item(2).Value 'marque
        uneLigne(3) = dgvPlancheDispo.CurrentRow.Cells.Item(3).Value 'taille
        uneLigne(4) = grpPV                                          'groupePV
        dgvMatLouer.Rows.Add(uneLigne)
        dgvPlancheDispo.Rows.Remove(dgvPlancheDispo.CurrentRow)

        'Voile
        dgvVoileDispo.Focus()
        uneLigne(0) = dgvVoileDispo.CurrentRow.Cells.Item(0).Value 'no
        uneLigne(1) = dgvVoileDispo.CurrentRow.Cells.Item(1).Value 'type
        uneLigne(2) = dgvVoileDispo.CurrentRow.Cells.Item(2).Value 'marque
        uneLigne(3) = dgvVoileDispo.CurrentRow.Cells.Item(3).Value 'taille
        uneLigne(4) = grpPV                                        'groupePV
        dgvMatLouer.Rows.Add(uneLigne)
        dgvVoileDispo.Rows.Remove(dgvVoileDispo.CurrentRow)
    End Sub


    'Supprime le matériel (la ligne) sélectionné dans dgvMatLouer et le rajoute dans la bonne liste (dgv*)
    '+ si planche ou voile, supprime aussi l'autre matériel
    Private Sub SupprimerMaterielListe()
        Dim uneLigne(5) As String

        uneLigne(0) = dgvMatLouer.CurrentRow.Cells.Item(0).Value 'no
        uneLigne(1) = dgvMatLouer.CurrentRow.Cells.Item(1).Value 'type
        uneLigne(2) = dgvMatLouer.CurrentRow.Cells.Item(2).Value 'marque
        uneLigne(3) = dgvMatLouer.CurrentRow.Cells.Item(3).Value 'taille
        uneLigne(4) = dgvMatLouer.CurrentRow.Cells.Item(4).Value 'groupe

        'rajoute dans la bonne liste (dgv*) selon le type (paddle, planche ou voile)
        Select Case uneLigne(1).ToLower
            Case "paddle"
                dgvPadDispo.Rows.Add(uneLigne)
            Case "planche"
                dgvPlancheDispo.Rows.Add(uneLigne)
                For Each row As DataGridViewRow In dgvMatLouer.Rows
                    If Not row.IsNewRow Then
                        'si le groupe est le même et que ce n'est pas le même matériel -> on a trouvé la voile
                        If row.Cells.Item(4).Value = uneLigne(4) And Not (row.Cells.Item(0).Value = uneLigne(0)) Then
                            Dim ligneTemp(5) As String
                            For i As Integer = 0 To 4
                                ligneTemp(i) = row.Cells.Item(i).Value
                            Next
                            dgvVoileDispo.Rows.Add(ligneTemp)
                            dgvMatLouer.Rows.Remove(row)
                        End If
                    End If
                Next
            Case "voile"
                dgvVoileDispo.Rows.Add(uneLigne)
                For Each row As DataGridViewRow In dgvMatLouer.Rows
                    If Not row.IsNewRow Then
                        'si le groupe est le même et que ce n'est pas le même matériel -> on a trouvé la planche
                        If row.Cells.Item(4).Value = uneLigne(4) And Not (row.Cells.Item(0).Value = uneLigne(0)) Then
                            Dim ligneTemp(5) As String
                            For i As Integer = 0 To 4
                                ligneTemp(i) = row.Cells.Item(i).Value
                            Next
                            dgvPlancheDispo.Rows.Add(ligneTemp)
                            dgvMatLouer.Rows.Remove(row)
                        End If
                    End If
                Next
        End Select
        'supprime le matériel sélectionné de la liste 
        dgvMatLouer.Rows.Remove(dgvMatLouer.CurrentRow)
    End Sub

    'Cré la location et les groupes de matériel
    Private Sub LouerMat()
        Dim reader_Sql As OracleDataReader
        Dim strRequete As String
        Dim noLoca As Integer

        'Création de la location
        strRequete = "INSERT INTO vw_locaMod VALUES('', to_date('" + Format(dtpDebut.Value, "dd.MM.yyyy HH:mm") + "','dd.mm.yyyy hh24:mi'), to_date('" + Format(DateAdd("h", nudDuree.Value, dtpDebut.Value), "dd.MM.yyyy HH:mm") + "','dd.mm.yyyy hh24:mi'), " + dgvClient.CurrentRow.Cells.Item(0).Value + ", 0)"
        do_sql(strRequete, reader_Sql)

        'Récupération du numéro de la nouvelle location 
        strRequete = "SELECT pkg_location.GetLastLocaNo FROM dual"
        do_sql(strRequete, reader_Sql)
        reader_Sql.Read()
        noLoca = reader_Sql.Item(0)

        'Location du matériel se trouvant dans dgvMatLouer
        For i As Integer = 0 To (dgvMatLouer.Rows.Count - 1) 'on parcours le DataGridView

            'PADDLE
            If dgvMatLouer.Rows.Item(i).Cells.Item(1).Value.ToString.ToLower = "paddle" Then
                'Création des groupes matériel (paddle) pour cette location
                strRequete = "INSERT INTO vw_matPadMod VALUES (" + noLoca.ToString + ", " + dgvMatLouer.Rows.Item(i).Cells.Item(0).Value.ToString + ")"
                do_sql(strRequete, reader_Sql)

                'PLANCHE A VOILE
            ElseIf (dgvMatLouer.Rows.Item(i).Cells.Item(1).Value.ToString.ToLower = "planche") Or (dgvMatLouer.Rows.Item(i).Cells.Item(1).Value.ToString.ToLower = "voile") Then
                For j As Integer = i + 1 To (dgvMatLouer.Rows.Count - 1) 'on parcours le reste du DataGridView
                    's'il fait parti du même groupe et que ce n'est pas le même item (car il n'y en a que 2) c'est respectivement la voile ou la planche
                    If dgvMatLouer.Rows.Item(j).Cells.Item(4).Value = dgvMatLouer.Rows.Item(i).Cells.Item(4).Value And Not (dgvMatLouer.Rows.Item(j).Cells.Item(0).Value = dgvMatLouer.Rows.Item(i).Cells.Item(0).Value) Then
                        'je modifie le type pour que ces items ne soient pas re traité sans modifier la longueur du tableau
                        dgvMatLouer.Rows.Item(i).Cells.Item(1).Value = "ok"
                        dgvMatLouer.Rows.Item(j).Cells.Item(1).Value = "ok"
                        'Création du groupe de matériel Planche à voile pour cette location
                        strRequete = "INSERT INTO vw_matPVMod VALUES (" + noLoca.ToString + ", " + dgvMatLouer.Rows.Item(i).Cells.Item(0).Value.ToString + ", " + dgvMatLouer.Rows.Item(j).Cells.Item(0).Value.ToString + ")"
                        do_sql(strRequete, reader_Sql)
                    End If
                Next
            ElseIf dgvMatLouer.Rows.Item(i).Cells.Item(1).Value.ToString.ToLower = "ok" Then
                'Ne rien faire
            End If
        Next
        frmMain.RefreshTabLocation()
    End Sub

    'Fonction qui retourne l'index du 1er item visible et le sélectionne dans la liste entré en paramètre
    'S'il n'y en a pas retourne -1
    Private Function FirstSelectedVisible(ByVal dgv As DataGridView) As Integer
        If dgv.Rows.Count <> 0 Then
            For i As Integer = 0 To dgv.Rows.Count - 1
                If dgv.Rows.Item(i).Visible = True Then
                    Return i
                End If
            Next
        End If
        Return -1
    End Function

    'Gère la disponibilité du bouton "Supprimer"
    Private Sub GererBtnSupprimer()
        'S'il a y quelque chose dans dgvMatLouer
        btnSupprimer.Enabled = dgvMatLouer.Rows.Count <> 0
    End Sub

    'Gère la disponibilité du bouton "Louer"
    Private Sub GererBtnLouer()
        'S'il y a quelque chose dans dgvMatLouer et dans dgvClient
        btnLouer.Enabled = dgvMatLouer.Rows.Count <> 0 And dgvClient.Rows.Count <> 0
    End Sub

    'Gère la disponibilité du bouton "Ajouter paddle"
    Private Sub GererBtnAjouterPad()

        btnAjouterPad.Enabled = FirstSelectedVisible(dgvPadDispo) <> -1

    End Sub

    'Gère la disponibilité du bouton "Ajouter planche à voile"
    Private Sub gererBtnAjouterPV()
        
        btnAjouterPV.Enabled = (FirstSelectedVisible(dgvPlancheDispo) <> -1 And FirstSelectedVisible(dgvVoileDispo) <> -1)

    End Sub

End Class