-- ====================================================================
-- Script : 01_BookMe.sql
-- Objet  : Creation BDD BookMe sur SGBD Oracle en Local (XE) 
--
-- Version  Visa   Date      Commentaires
-- -----  ------ --------    ---------------------------------------------
-- 1.0	     NP              Creation
-- ====================================================================

SET ECHO ON
SET LINESIZE 200
SET PAGESIZE 60

-- Creation des utilisateurs en tant que System
SPOOL .\Logs\02_utilisateurs_BookMe.log
@.\02_utilisateurs_bookMe.sql;
SPOOL OFF

-- Connexion a XE en tant que bookMe_data (propiretaires des objets de schema)
CONNECT BookMe_data/BookMe_data@XE

-- Creation des tables
SPOOL .\Logs\03_tables_BookMe.log
@.\03_tables_BookMe.sql;
SPOOL OFF

-- Chargement des donnes
SPOOL .\Logs\04_insertions_BookMe.log
@.\04_insertions_BookMe.sql;
SPOOL OFF

-- Creation des vues
SPOOL .\Logs\05_vues_BookMe.log
@.\05_vues_BookMe.sql;
SPOOL OFF

-- Creation des triggers pour les clefs primaires
SPOOL .\Logs\06_triggers_BookMe.log
@.\06_triggers_BookMe.sql;
SPOOL OFF

-- Creation des packages
SPOOL .\Logs\07_package_BookMe.log
@.\07_package_BookMe.sql;
SPOOL OFF

-- Connexion a XE en tant que system
CONNECT system/manager@XE

-- Creation des synonymes
SPOOL .\Logs\08_synonymes_BookMe.log
@.\08_synonymes_BookMe.sql;
SPOOL OFF

SET ECHO OFF

EXIT;
