-- ====================================================================
-- Script : 02_utilisateurs_BookMe.sql
-- Objet  : Cration des utilisateurs BDD BookMe sur SGBD Oracle en Local (HEGLOCAL)
--
-- Mise a jour des versions
-- Version  Visa   Date      Commentaires
-- -----  ------ --------    ------------------------------------------
-- 1.0	     GA   26.03.07    Cration utilisateurs
-- ====================================================================
-- =============================================================================================
-- Suppression des roles, utilisateurs et profil
-- =============================================================================================
-- Suppression des utilisateurs et de ce qui en dcoule
DROP USER BookMe_data CASCADE;
DROP USER BookMe_user CASCADE;

-- Suppression des rles et de ce qui en dcoule
DROP ROLE role_BookMe_data CASCADE;
DROP ROLE role_BookMe_user CASCADE;

-- Suppression du profil
DROP PROFILE BookMe_profil;

-- =============================================================================================
-- Creation du profil
-- =============================================================================================
-- Creation du profil BookMe_profil
CREATE PROFILE BookMe_profil LIMIT
	SESSIONS_PER_USER 3
	FAILED_LOGIN_ATTEMPTS 3 
	PASSWORD_LOCK_TIME 1/24
	PASSWORD_LIFE_TIME 180 
	PASSWORD_REUSE_TIME 180 
	PASSWORD_REUSE_MAX UNLIMITED
	PASSWORD_GRACE_TIME 7;

-- =============================================================================================
-- Creation du role role_BookMe_data (role de l'utilisateur propritaire des objets de la base)
-- =============================================================================================
-- Creation du rle role_BookMe_data
CREATE ROLE role_BookMe_data;

-- droit de se connecter  la BDD
GRANT CONNECT TO role_BookMe_data;

-- droit de crer des triggers, squence, tables, packages, ...
GRANT RESOURCE TO role_BookMe_data;

-- droit de crer des vues
GRANT CREATE VIEW TO role_BookMe_data;

-- droit de crer des synonymes
-- GRANT CREATE ANY SYNONYM TO role_BookMe_data;
-- ! fonctionne mais donne trop de privilges,  viter

-- ===============================
-- Creation du role role_BookMe_user (role de l'utilisateur de l'application)
-- ===============================
-- Creation du rle role_BookMe_user
CREATE ROLE role_BookMe_user;

-- droit de se connecter  la BDD
GRANT CREATE SESSION TO role_BookMe_user;

-- ===================================
-- Creation de l'utilisateur BookMe_data (proprietaire des objets de schma de la base)
-- ===================================
-- Creation de l'utilisateur BookMe_data 
CREATE USER BookMe_data
	PROFILE BookMe_profil
	IDENTIFIED BY BookMe_data
	DEFAULT TABLESPACE USERS
	TEMPORARY TABLESPACE TEMP
;
GRANT role_BookMe_data TO BookMe_data;
ALTER USER BookMe_data quota unlimited ON USERS;

--===================================
--Creation de l'utilisateur BookMe_user (utilisateur de l'application)
--===================================
CREATE USER BookMe_user
	PROFILE BookMe_profil
	IDENTIFIED BY BookMe_user
;
GRANT role_BookMe_user TO BookMe_user;
