-- ====================================================================
-- Script : 03_tables_BookMe.sql
-- Objet  : Creation et suppression des tables
-- ====================================================================
-- ====================================================
-- Suppression des tables
-- ====================================================
DROP TABLE bm_matPad CASCADE CONSTRAINT;
DROP TABLE bm_matPV  CASCADE CONSTRAINT;
DROP TABLE bm_loca   CASCADE CONSTRAINT;
DROP TABLE bm_pers   CASCADE CONSTRAINT;
DROP TABLE bm_stock  CASCADE CONSTRAINT;
-- ====================================================
-- Creation des tables
-- ====================================================
-- ====================================================
-- Table : bm_stock
-- ====================================================
CREATE TABLE bm_stock (
	stock_no      		NUMBER(5) CONSTRAINT pk_stock_no PRIMARY KEY,
    stock_type	  		VARCHAR(20) NOT NULL, 
    stock_marque  		VARCHAR2(30)NOT NULL,
    stock_taille  		NUMBER(3) NOT NULL,
	stock_isArchive		NUMBER(1) NOT NULL
);
-- ====================================================
-- Table : bm_pers
-- + pers_adresse et pers_mail ne sont pas obligatoire (selon demande du mandant)
-- ====================================================
CREATE TABLE bm_pers (
	pers_no      NUMBER(5) CONSTRAINT pk_pers_no PRIMARY KEY,
	pers_nom     VARCHAR2(30) NOT NULL,
	pers_prenom  VARCHAR2(30) NOT NULL,
	pers_tel     VARCHAR2(20) NOT NULL,
	pers_adresse VARCHAR2(50),
	pers_mail    VARCHAR2(30),
	pers_isAdmin NUMBER(1) NOT NULL,
	pers_isArchive NUMBER(1) NOT NULL
);
-- ====================================================
-- Table : bm_loca
-- ====================================================
CREATE TABLE bm_loca (
    loca_no          NUMBER(5) CONSTRAINT pk_loca_no PRIMARY KEY,
	loca_heureDebut  DATE NOT NULL,
	loca_heureFin    DATE NOT NULL,
	loca_pers_no     NUMBER(5) NOT NULL CONSTRAINT fk_loca_pers_no REFERENCES bm_pers(pers_no),
    loca_isArchive   NUMBER(1) NOT NULL
);

-- ====================================================
-- Table : bm_matPV
-- ====================================================
CREATE TABLE bm_matPV (
	matPV_loca_no    NUMBER(5) NOT NULL CONSTRAINT fk_bm_matPV_bm_loca   REFERENCES bm_loca (loca_no),
	matPV_stock_no1  NUMBER(5) NOT NULL CONSTRAINT fk_bm_matPV_bm_stock1 REFERENCES bm_stock (stock_no),
	matPV_stock_no2  NUMBER(5) NOT NULL CONSTRAINT fk_bm_matPV_bm_stock2 REFERENCES bm_stock (stock_no),
    CONSTRAINT pk_matPV PRIMARY KEY (matPV_loca_no, matPV_stock_no1, matPV_stock_no2)  
);

-- ====================================================
-- Table : bm_matPad
-- ====================================================
CREATE TABLE bm_matPad (
	matPad_loca_no 		NUMBER(5) NOT NULL CONSTRAINT fk_bm_matPad_bm_resPad REFERENCES bm_loca (loca_no),
	matPad_stock_no 	NUMBER(5) NOT NULL CONSTRAINT fk_bm_matPad_bm_stock  REFERENCES bm_stock (stock_no),
    CONSTRAINT pk_bm_matPad PRIMARY KEY (matPad_loca_no, matPad_stock_no)  
);

-- ====================================================
-- Table : bm_pwd
-- ====================================================
CREATE TABLE bm_pwd (
	pwd_pers_no 		NUMBER(5) NOT NULL CONSTRAINT fk_pwd_pers_no REFERENCES bm_pers (pers_no),
	pwd_md5				VARCHAR2(32),
    CONSTRAINT pk_bm_pwd PRIMARY KEY (pwd_pers_no, pwd_md5)
);
