-- ======================================================================
--  Script: 05_vues_BookMe.sql 
--  Objet : Creation des vues schema de la base BookMe
--  Objectif : creer des vues et tester l'interrogation et la mise a jour a travers ces vues. 
-- ======================================================================

-- ====================================================
-- Creation des VUES
-- ====================================================
-- ====================================================
-- Vue d'affichage des personnes restrainte (sans info admin)
-- qui ne sont pas archive
-- ====================================================
CREATE OR REPLACE VIEW vw_pers AS
       SELECT pers_no, pers_nom, pers_prenom, pers_tel, pers_adresse, pers_mail
       FROM bm_pers
		WHERE pers_isArchive = 0
         ORDER BY pers_nom, pers_prenom
;
GRANT SELECT ON vw_pers TO BookMe_user;

-- ====================================================
-- Vue d'affichage du stock
-- materiel qui n'est pas archive
-- ====================================================
CREATE OR REPLACE VIEW vw_stock AS
       SELECT stock_no, stock_type, stock_marque, stock_taille
       FROM bm_stock
		WHERE stock_isArchive = 0
         ORDER BY stock_no
;
GRANT SELECT ON vw_stock TO BookMe_user;

-- ====================================================
-- Vue d'affichage du matriel et
-- des horaires de sa location
-- ====================================================
CREATE OR REPLACE VIEW vw_stockLoca AS
		SELECT stock_no, stock_type, stock_marque, stock_taille, loca_no, loca_heureDebut, loca_heureFin, loca_isArchive
		FROM bm_stock, bm_matPV, bm_loca
		WHERE 	stock_isArchive = 0
			AND (matPV_stock_no1 = stock_no OR matPV_stock_no2 = stock_no)
			AND matPV_loca_no = loca_no
		UNION ALL
		SELECT stock_no, stock_type, stock_marque, stock_taille, loca_no, loca_heureDebut, loca_heureFin, loca_isArchive
		FROM bm_stock, bm_matPad, bm_loca
		WHERE 	stock_isArchive = 0
			AND matPad_stock_no = stock_no
			AND matPad_loca_no = loca_no
		ORDER BY stock_no
;
GRANT SELECT ON vw_stockLoca TO BookMe_user;

-- ====================================================
-- Vue d'affichage des locations et du client loueur
-- ====================================================
CREATE OR REPLACE VIEW vw_locaClient AS
       SELECT loca_no, pers_prenom, loca_heureDebut, loca_heureFin,
			  pers_no, pers_nom, pers_tel, pers_adresse, pers_mail, loca_isArchive
       FROM bm_loca, bm_pers
            WHERE loca_pers_no = pers_no
         ORDER BY loca_heureDebut, loca_heureFin
;
GRANT SELECT ON vw_locaClient TO BookMe_user;

-- ====================================================
-- Vue d'affichage des groupes de matriel(PV + Pad)
-- du numro de location et de son tat d'archivage
-- ====================================================
CREATE OR REPLACE VIEW vw_matLoca AS
       SELECT stock_no, stock_type, stock_marque, stock_taille, loca_no, loca_isArchive
		FROM bm_stock, bm_matPV, bm_loca
			WHERE (stock_no = matPV_stock_no1 OR stock_no = matPV_stock_no2)
			  AND (loca_no = matPV_loca_no)
		UNION ALL
		SELECT stock_no, stock_type, stock_marque, stock_taille, loca_no, loca_isArchive
		FROM bm_stock, bm_matPad, bm_loca
			WHERE (stock_no = matPad_stock_no)
			  AND (loca_no = matPad_loca_no)
       ORDER BY loca_no DESC
;
GRANT SELECT ON vw_matLoca TO BookMe_user;

-- ====================================================
-- Vue d'affichage des groupes de matriel (PV + Pad) 
-- et du numro de client ayant fait la location
-- ====================================================
CREATE OR REPLACE VIEW vw_matClient AS
       SELECT stock_no, stock_type, stock_marque, stock_taille, loca_pers_no
		FROM vw_matLoca, bm_loca
			WHERE (vw_matLoca.loca_no = bm_loca.loca_no)
       --ORDER BY matPV_loca_no, stock_type, stock_taille, stock_marque
;
GRANT SELECT ON vw_matClient TO BookMe_user;

-- ====================================================
-- Vue 1:1 pour la modification des locations
-- ====================================================
CREATE OR REPLACE VIEW vw_locaMod AS
       SELECT * FROM bm_loca
;
GRANT SELECT, INSERT, UPDATE, DELETE ON vw_locaMod TO BookMe_user;

-- ====================================================
-- Vue 1:1 pour la modification du stock 
-- ====================================================
CREATE OR REPLACE VIEW vw_stockMod AS
       SELECT * FROM bm_stock
;
GRANT SELECT, INSERT, UPDATE, DELETE ON vw_stockMod TO BookMe_user;

-- ====================================================
-- Vue 1:1 pour la modification des personnes
-- ====================================================
CREATE OR REPLACE VIEW vw_persMod AS
       SELECT * FROM bm_pers
;
GRANT SELECT, INSERT, UPDATE, DELETE ON vw_persMod TO BookMe_user;

-- ====================================================
-- Vue 1:1 pour la modification de bm_matPV 
-- ====================================================
CREATE OR REPLACE VIEW vw_matPVMod AS
       SELECT * FROM bm_matPV
;
GRANT SELECT, INSERT, UPDATE, DELETE ON vw_matPVMod TO BookMe_user;

-- ====================================================
-- Vue 1:1 pour la modification de bm_matPad 
-- ====================================================
CREATE OR REPLACE VIEW vw_matPadMod AS
       SELECT * FROM bm_matPad
;
GRANT SELECT, INSERT, UPDATE, DELETE ON vw_matPadMod TO BookMe_user;

-- ====================================================
-- Vue 1:1 pour les mots de passe 
-- ====================================================
CREATE OR REPLACE VIEW vw_pwd AS
		SELECT * FROM bm_pwd
;
GRANT SELECT, INSERT, UPDATE, DELETE ON vw_pwd TO BookMe_user;