-- ====================================================================
-- Script : 06_triggers_BookMe.sql
-- Objet  : Creation des triggers BookMe sur SGBD Oracle en Local (XE) 
--
-- Mise  jour des versions
-- Version  Visa   Date      Commentaires
-- -----  ------ --------    ------------------------------------------
-- 1.0	     GA   2.05.08    Creation trigers
-- ====================================================================

-- ====================================================
-- Trigger bm_pers
-- ====================================================
--Gnration automatique du pers_no  l'insertion d'une nouvelle ligne
 CREATE SEQUENCE sq_pers  MINVALUE 1 NOMAXVALUE INCREMENT BY 1 START WITH 20 CACHE 20 NOORDER  NOCYCLE
/

CREATE OR REPLACE TRIGGER  tr_pers 
  BEFORE INSERT ON bm_pers               
  FOR EACH ROW  
BEGIN   
    SELECT sq_pers.nextval INTO :NEW.pers_no FROM dual; 
END; 

/
ALTER TRIGGER  tr_pers ENABLE
/
-- ====================================================
-- Trigger bm_stock
-- ====================================================
--Gnration automatique du stock_no  l'insertion d'une nouvelle ligne
 CREATE SEQUENCE   sq_stock  MINVALUE 1 NOMAXVALUE INCREMENT BY 1 START WITH 30 CACHE 20 NOORDER  NOCYCLE
/

CREATE OR REPLACE TRIGGER  tr_stock 
  BEFORE INSERT ON bm_stock               
  FOR EACH ROW  
BEGIN   
    SELECT sq_stock.nextval INTO :NEW.stock_no FROM dual; 
END; 

/
ALTER TRIGGER  tr_stock ENABLE
/
-- ====================================================
-- Trigger bm_loca
-- ====================================================
--Gnration automatique du loca_no  l'insertion d'une nouvelle ligne
 CREATE SEQUENCE   sq_loca  MINVALUE 1 NOMAXVALUE INCREMENT BY 1 START WITH 20 CACHE 20 NOORDER  NOCYCLE
/

CREATE OR REPLACE TRIGGER  tr_loca 
  BEFORE INSERT ON bm_loca               
  FOR EACH ROW  
BEGIN   
    SELECT sq_loca.nextval INTO :NEW.loca_no FROM dual; 
END; 

/
ALTER TRIGGER  tr_loca ENABLE
/

--Effacement automatique des groupes de matriel associs  la location  effacer
CREATE OR REPLACE TRIGGER  tr_deleteLoca 
	BEFORE DELETE ON bm_loca
	FOR EACH ROW
  BEGIN
    DELETE FROM bm_matPV  WHERE matPV_loca_no = :OLD.loca_no;
    DELETE FROM bm_matPad WHERE matPad_loca_no = :OLD.loca_no;
  END;
   
/
ALTER TRIGGER  tr_deleteLoca ENABLE
/
