package gestionnaire;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;

import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;

import modele.Commande;
import modele.Employe;
import transport.AtomCapsules;
import transport.AtomCommande;
import transport.AtomCommandes;
import transport.AtomEmploye;
import transport.AtomEmployes;

public class GestionnaireCommandes {
	
	/*Instance unique (static)*/
	public static GestionnaireCommandes uniqueInstance = new GestionnaireCommandes();
	
	private GestionnaireCommandes(){}
	
	/*SInstance unique (static)*/
	public static GestionnaireCommandes getUniqueInstance(){
		return uniqueInstance;
	}
	
	/** ATOM : Rcupre la liste des employs */
	public AtomEmployes getListeEmployes() throws Exception{
		//L'objet qui sera Unmarshall et retourn
		AtomEmployes atomEmployes = null;
		
		//Http request
	  String url ="http://localhost:8080/TPRattrapageServeur/ListeEmployes"; //@Path("ListeEmployes")
		HttpClient client = HttpClientBuilder.create().build();
		HttpGet request = new HttpGet(url); //@GET ct serveur
		request.setHeader(HttpHeaders.ACCEPT, MediaType.APPLICATION_ATOM_XML); //@Produces(MediaType.APPLICATION_ATOM_XML)
		HttpResponse response = client.execute(request);
		
		if(response.getStatusLine().getStatusCode()<300){
			try {
				//Unmarshalling
				JAXBContext jaxbContext = JAXBContext.newInstance(AtomEmployes.class);
				Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
				atomEmployes = (AtomEmployes) unmarshaller.unmarshal(response.getEntity().getContent());;
			} catch (Exception e) {e.printStackTrace();}
		}
		return atomEmployes;
	}//getListeEmployes

	
	/** ATOM : Rcupre la liste des commandes pour un employ e*/
	public AtomCommandes getListeCommandesEmploye(Employe e) throws Exception{
		//L'objet qui sera Unmarshall et retourn
		AtomCommandes atomCommandes= null;
		try{
			OutputStream os = new ByteArrayOutputStream();
			
			//Marshalling d'AtomEmploye
			JAXBContext jaxbContext = JAXBContext.newInstance(AtomEmploye.class);
			Marshaller marshaller = jaxbContext.createMarshaller();
			AtomEmploye atomEmploye = new AtomEmploye(e);
			marshaller.marshal(atomEmploye, os);
			
			//Http request
		  String url ="http://localhost:8080/TPRattrapageServeur/ListeCommandeEmploye"; //@Path("ListeCommandeEmploye")
			HttpClient client = HttpClientBuilder.create().build();
			HttpPut request = new HttpPut(url); //@PUT cot serveur
			request.setHeader(HttpHeaders.CONTENT_TYPE,MediaType.APPLICATION_ATOM_XML); //@Consumes(MediaType.APPLICATION_ATOM_XML) - Envoie AtomEmploye
			request.setHeader(HttpHeaders.ACCEPT, MediaType.APPLICATION_ATOM_XML); //@Produces(MediaType.APPLICATION_ATOM_XML) - Recois AtomCommandes
			request.setEntity(new StringEntity(os.toString(),"UTF-8"));
			HttpResponse response = client.execute(request);
			
			if(response.getStatusLine().getStatusCode()<300){
				try {
					//Unmarshalling de AtomCommandes
					jaxbContext = JAXBContext.newInstance(AtomCommandes.class);
					Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
					atomCommandes = (AtomCommandes) unmarshaller.unmarshal(response.getEntity().getContent());
				} catch (Exception ee) {ee.printStackTrace();}
			}//if
		}catch(Exception ee){ee.printStackTrace();}
		
		return atomCommandes;
	}//getListeCommandesEmploye
	
	
	/** TEXT : Rcupre la liste des commandes pour un employ e*/
	public BufferedReader getListeCommandesEmployeTxt(Employe e) throws Exception{
		//L'objet qui sera retourn
		BufferedReader br = null;
		try{
			String idEmp = Integer.toString(e.getId());
			
			//Http request
			//Il y a 2x la mme URL, JAX-RS utilisera celle dont les types correspondent
		  String url ="http://localhost:8080/TPRattrapageServeur/ListeCommandeEmploye"; //@Path("ListeCommandeEmploye")
			HttpClient client = HttpClientBuilder.create().build();
			HttpPut request = new HttpPut(url); //@PUT cot serveur
			request.setHeader(HttpHeaders.CONTENT_TYPE,MediaType.TEXT_PLAIN); //@Consumes(MediaType.TEXT_PLAIN) - Envoie text Employ
			request.setHeader(HttpHeaders.ACCEPT, MediaType.TEXT_PLAIN); //@Produces(MediaType.TEXT_PLAIN) - Recois text Commandes
			request.setEntity(new StringEntity(idEmp,"UTF-8")); //Ajoute l'id de l'employ
			HttpResponse response = client.execute(request);
			
			if(response.getStatusLine().getStatusCode()<300){
				br = new BufferedReader(new 
						InputStreamReader(response.getEntity().getContent()));
			}//if	
		}catch(Exception ee){ee.printStackTrace();}
			
		return br;
	}//getListeCommandesEmployeTxt
	
}//GestionnaireCommandes
