package modele;

import java.text.DecimalFormat;


public class Commande {
  
  private static final DecimalFormat FORMAT = new DecimalFormat("#0.00 CHF");
  
  private Employe employe; /* L'employ concern par la commande */
  private Capsule capsule; /* La capsule concerne par la commande */
  private int nombre;      /* Le nombre de capsules commandes */
  
  /** Constructeurs */
  public Commande (Employe employe, Capsule capsule, int nombre) {
    this.employe = employe; this.capsule = capsule; this.nombre = nombre;
  } 
  public Commande(){}

  /** Accesseurs */
  public Capsule getCapsule () {return capsule;}
  public int getNombre () {return nombre;}

  public double getPrix () {return nombre * capsule.getPrix();}
  
  public Employe getEmploye() {
		return employe;
	}
	
	public void setEmploye(Employe employe) {
		this.employe = employe;
	}
	
	public void setCapsule(Capsule capsule) {
		this.capsule = capsule;
	}
	
	public void setNombre(int nombre) {
		this.nombre = nombre;
	}

	@Override
  public boolean equals (Object obj) {return ((Commande)obj).employe.equals(employe) && ((Commande)obj).capsule.equals(capsule);}
  
  @Override
  public String toString () {return nombre + " x " + capsule.getNom() + "  " + FORMAT.format(capsule.getPrix());}
  
  public String toStringTxt () {return capsule.toString() +" "+ nombre*capsule.getPrix();}
  //public String toStringTxt () {return capsule.getNom() + " [" + FORMAT.format(capsule.getPrix())+"] "+ nombre*capsule.getPrix();}

} // Commande
