package presentation;

import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.text.DecimalFormat;
import java.util.ArrayList;

import gestionnaire.GestionnaireCommandes;
import modele.Commande;
import modele.Employe;
import transport.AtomCommandes;
import transport.AtomEmployes;


public class FrmMain extends java.awt.Frame {
  
  private static final String AUCUNE = "<Aucune>";
  
  private AtomEmployes listeEmployes;   //Objet liste des employs manipulable cot display
  private AtomCommandes listeCommandes; //Objet liste de commande manipulable cot display
  private GestionnaireCommandes gestionnaireCommandes; //Ensemble des Http request 

  /** Constructeur 
 * @throws Exception */
  public FrmMain() throws Exception {
	  gestionnaireCommandes = GestionnaireCommandes.getUniqueInstance(); //Rcupre une instance unique du gestionnaire de commandes
	  initComponents();
    chargerEmployes();
  } //Constructeur

  /* Charge les employs dans la liste pour le display (et slectionne le premier) */
  private void chargerEmployes() throws Exception {
    listeEmployes = gestionnaireCommandes.getListeEmployes();
    //System.out.println(listeEmployes.getEntries().size()); // -> 20
    if (listeEmployes != null){ //Si la liste n'est pas vide
	    for (int i = 0; i < listeEmployes.getEntries().size(); i++) {
	    	lstEmployes.add(listeEmployes.getEntries().get(i).getContents().getNom());
	    }
    //slection du 1er lment
    chFormat.select(0);
    lstEmployes.select(0);
    selectEmploye(0);
    }//if
  } //chargerEmployes
  
  
  /* Slection d'un employ: affichage de ses commandes. */
  private void selectEmploye(int pos) throws Exception{
    lstEmployes.select(pos); //on slectionne la position
    Employe e = listeEmployes.getEntries().get(pos).getContents(); //On rcupre l'employ
    
    lstCommandes.removeAll();
    
    //Si format TEXT -> Affichage dans console Java ct client.
    if (chFormat.getSelectedItem().equals("Text")) {
    	BufferedReader listeCommandesTxt = gestionnaireCommandes.getListeCommandesEmployeTxt(e); //on rcupre la liste au format txt
    	String line = listeCommandesTxt.readLine();
    	while(line != null){
    		System.out.println(line);
    		line = listeCommandesTxt.readLine();
    	}
    }//if Text
    
    //Si format ATOM -> Affichage dans l'application.
    if (chFormat.getSelectedItem().equals("Atom")) {
    	listeCommandes = gestionnaireCommandes.getListeCommandesEmploye(e); //on rcupre la liste au format Atom
	    if ( listeCommandes.getEntries()!= null){
		    for (int k = 0; k < listeCommandes.getEntries().size(); k++) {
		      lstCommandes.add(listeCommandes.getEntries().get(k).getContents().toString());
		    }//for
		    if (listeCommandes.getEntries().size() == 0) {lstCommandes.add(AUCUNE);}
	    }//if !null
    }// if Atom
    
  } //selectEmploye
  
  
  
  /**
   * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The content of this method
   * is always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    label1 = new java.awt.Label();
    lstEmployes = new java.awt.List();
    lblCommandes = new java.awt.Label();
    lstCommandes = new java.awt.List();
    label2 = new java.awt.Label();
    chFormat = new Choice();

    setResizable(true);
    setTitle("Commandes de capsules de caf");
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosed(java.awt.event.WindowEvent evt) {
        formWindowClosed(evt);
      }
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    label1.setText("Employs");
    
    lstEmployes.addItemListener(new java.awt.event.ItemListener() {
        public void itemStateChanged(java.awt.event.ItemEvent evt) {
          try {
  					lstEmployesItemStateChanged(evt);
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
        }
    });

    //Bonus : Rajout d'un listner pour tre plus user frendly
    chFormat.addItemListener(new java.awt.event.ItemListener() {
        public void itemStateChanged(java.awt.event.ItemEvent evt) {
          try {
        	  chFormatItemStateChanged(evt);
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
        }
    });
   

    lblCommandes.setText("Commandes");

    lstCommandes.setEnabled(false);

    label2.setText("Format : ");

    chFormat.add("Atom");
    chFormat.add("Text");
    //chFormat.select("Atom");

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
    this.setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(label1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(lstEmployes, javax.swing.GroupLayout.PREFERRED_SIZE, 157, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addGap(29, 29, 29)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
          .addGroup(layout.createSequentialGroup()
            .addComponent(label2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addGap(21, 21, 21)
            .addComponent(chFormat, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
          .addComponent(lblCommandes, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          
          .addComponent(lstCommandes, javax.swing.GroupLayout.DEFAULT_SIZE, 232, Short.MAX_VALUE))
        .addContainerGap(19, Short.MAX_VALUE))
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(label1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addComponent(lblCommandes, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(lstEmployes, javax.swing.GroupLayout.PREFERRED_SIZE, 250, javax.swing.GroupLayout.PREFERRED_SIZE)
          .addGroup(layout.createSequentialGroup()
            .addComponent(lstCommandes, javax.swing.GroupLayout.PREFERRED_SIZE, 186, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
              .addComponent(label2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
              .addComponent(chFormat, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(label2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(chFormat, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                  .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            //.addComponent(chFormat, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    )));

    pack();
  }// </editor-fold>//GEN-END:initComponents

  /* Fermeture de la fentre */
  private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
    //ConnexionBase.close();
    System.exit(0);
  }//GEN-LAST:event_formWindowClosed

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    dispose();
  }//GEN-LAST:event_formWindowClosing

  
  
  /* Un employ a t slectionn */
  private void lstEmployesItemStateChanged(java.awt.event.ItemEvent evt) throws Exception{//GEN-FIRST:event_lstEmployesItemStateChanged
	  selectEmploye(lstEmployes.getSelectedIndex());
  }
  
  
  /*Bonus : Un format a t slectionn */
  private void chFormatItemStateChanged(java.awt.event.ItemEvent evt) throws Exception{//GEN-FIRST:event_lstEmployesItemStateChanged
	  selectEmploye(lstEmployes.getSelectedIndex());
  }
  
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private java.awt.Choice chFormat;
  private java.awt.Label label1;
  private java.awt.Label label2;
  private java.awt.Label lblCommandes;
  private java.awt.List lstCommandes;
  private java.awt.List lstEmployes;
  // End of variables declaration//GEN-END:variables

} // FrmMain
