package transport;

import java.util.Calendar;

import javax.ws.rs.core.MediaType;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import modele.Capsule;

@XmlRootElement(name="entry")
@XmlAccessorType(XmlAccessType.NONE) //Seul ceux spcifis
public class AtomCapsule extends AtomConstruct{
	
	@XmlElement(name="content")
	private Capsule content;
	
	/** Constructeurs */
	public AtomCapsule(){} //vide obligatoire
	public AtomCapsule(String baseURL,Capsule caps ,boolean fullEntry){
		String capsuleId = new Integer(caps.getId()).toString();
		String selfURL = baseURL + "/"+ capsuleId;
		
		//Setter les 3 obligatoire d'AtomConstruct
		setId(selfURL);
		setTitle("Capsule "+ capsuleId);
		setUpdated(Calendar.getInstance().getTime().toString());
		
		if(fullEntry) {
			this.content = caps;
			addLink(new AtomLink("edit",selfURL,"Atom+Xml"));
			addLink(new AtomLink("delete",selfURL+"/delete","Atom+Xml"));
		}
		else addLink(new AtomLink("alternate",selfURL,MediaType.APPLICATION_ATOM_XML));
	}
	
	//Accs  l'objet
	public Capsule getContents(){
		return content;
	}	

}
