package transport;

import java.util.ArrayList;
import java.util.Calendar;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import modele.Capsule;

@XmlRootElement(name="feed")
@XmlAccessorType(XmlAccessType.NONE) //vide obligatoire
public class AtomCapsules extends AtomConstruct{
	
	@XmlElement(name="entry")
	private ArrayList<AtomCapsule> entries = new ArrayList<AtomCapsule>();
	
	public AtomCapsules(){}
	public AtomCapsules(String baseURL, ArrayList<Capsule> listeCapsules){
		
		//Setter les 3 obligatoires d'AtomConstruct
		setId(baseURL);
		setTitle("Capsules");
		setUpdated(Calendar.getInstance().getTime().toString());
		
		//AtomLink sur lui-mme
		addLink(new AtomLink("self",baseURL,"Atom+Xml"));
		
		//Dans le constructeur pour populer la liste d'objet Atom
		for(Capsule c : listeCapsules){
			entries.add(new AtomCapsule(baseURL,c,true));
		}
	}//AtomCapsules(...)
	
	//Accs  l'objet
	public ArrayList<AtomCapsule> getEntries(){
		return entries;
	}

}
