package transport;

import java.util.ArrayList;
import java.util.Calendar;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import modele.Commande;

@XmlRootElement(name="feed")
@XmlAccessorType(XmlAccessType.NONE) //Seul ceux spcifis
public class AtomCommandes extends AtomConstruct{
	
	@XmlElement(name="entry")
	private ArrayList<AtomCommande> entries = new ArrayList<AtomCommande>();
	
	/** Constructeurs */
	public AtomCommandes(){}
	public AtomCommandes(String baseURL, ArrayList<Commande> alc){
		
		//Setter les 3 obligatoires d'AtomConstruct
		setId(baseURL);
		setTitle("Commandes");
		setUpdated(Calendar.getInstance().getTime().toString());
		
		//AtomLink sur lui-mme
		addLink(new AtomLink("self",baseURL,"Atom+Xml"));
		
		//Dans le constructeur pour populer la liste d'objet Atom
		for(Commande com : alc){
			entries.add(new AtomCommande(baseURL,com,true));
		}
	}//AtomCommandes
	
	//Accs  l'objet
	public ArrayList<AtomCommande> getEntries(){
		return entries;
	}

}
