package base;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;

import modele.Capsule;
import modele.Commande;
import modele.Employe;

public class CommandeDao {
  
  private static final Calendar CAL = Calendar.getInstance();
  
  /** Retourne la liste des commandes pour l'employ emp, les commandes sont regroupes par capsule. */
  public static ArrayList<Commande> getListeCommandes (Employe emp) {
    ArrayList<Commande> liste = new ArrayList<Commande>();
    try {
      Connection con = ConnexionBase.get();
      Statement stmt = con.createStatement();
      ResultSet rs = stmt.executeQuery("SELECT IdCapsule, Nombre FROM Commande WHERE IdEmploye = " + emp.getId() + " ORDER BY IdCapsule");
      if (rs.next()) {
        int idCapsule = rs.getInt("IdCapsule"); int nombreTotal = rs.getInt("Nombre");
        Capsule capsule = CapsuleDao.getCapsule(idCapsule);
        while (rs.next()) {
          int idC = rs.getInt("IdCapsule"); int nb = rs.getInt("Nombre");
          if (idC == idCapsule) {
            nombreTotal += nb;
          } else {
            liste.add(new Commande(emp, capsule, nombreTotal));
            idCapsule = idC; nombreTotal = nb;
            capsule = CapsuleDao.getCapsule(idCapsule);
          }
        }
        liste.add(new Commande(emp, capsule, nombreTotal));
      }
      stmt.close();
    }
    catch (SQLException e) {System.out.println("CommandeDao.getListeCommandes(): " + e.getMessage()); e.printStackTrace();}
    return liste;
  } // getListeCommandes
  
  /** Enregistre la commande de nbCapsules capsules pour l'employ emp */
  public static void enregistreCommande (Employe emp, Capsule cap, int nbCapsules) {
    try {
      Connection con = ConnexionBase.get();
      String sql = "INSERT INTO Commande (IdEmploye, IdCapsule, Nombre, Date) VALUES (?, ?, ?, ?)";
      PreparedStatement stmt = con.prepareStatement(sql);
      stmt.setInt(1, emp.getId()); 
      stmt.setInt(2, cap.getId());
      stmt.setInt(3, nbCapsules); 
      stmt.setDate(4, new Date(CAL.getTimeInMillis()));
      stmt.executeUpdate();
      stmt.close();
    }
    catch (SQLException e) {System.out.println("CommandeDAO.insert(): " + e.getMessage()); e.printStackTrace();}
  } // enregistreCommande
  
  /** Supprimer la commande  */
  public static void SupprimeCommande (String id) {
    try {
      Connection con = ConnexionBase.get();
      String sql = "DELETE FROM Commande WHERE IdEmploye=?";
      PreparedStatement stmt = con.prepareStatement(sql);
      stmt.setString(1, id); 
      stmt.executeUpdate();
      stmt.close();
    }
    catch (SQLException e) {System.out.println("CommandeDAO.delete(): " + e.getMessage()); e.printStackTrace();}
  } // SupprimeCommande
  
} // CommandeDao
