package modele;

import java.text.DecimalFormat;


public class Capsule {

  private static final DecimalFormat FORMAT = new DecimalFormat("#0.00 CHF");
  
  private int id;      /* Identifiant */
  private String nom;  /* Nom */
  private double prix; /* Prix */

  /** Constructeurs */
  public Capsule (int id, String nom, double prix) {
    this.id = id;
    this.nom = nom; this.prix = prix;
  }
  public Capsule(){}
  
  /** Accesseurs */
  public int getId () {return id;}
  public String getNom () {return nom;}
  public double getPrix () {return prix;}
  
  public void setId(int id) {
		this.id = id;
	}
	
	public void setNom(String nom) {
		this.nom = nom;
	}
	
	public void setPrix(double prix) {
		this.prix = prix;
	}

  @Override
  public boolean equals (Object obj) {return ((Capsule)obj).id == id;}
  
  @Override
  public String toString () {return nom + " [" + FORMAT.format(prix) + "]";}
  
} // Capsule
