package transport;

import java.util.Calendar;

import javax.ws.rs.core.MediaType;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import modele.Commande;

@XmlRootElement(name="entry")
@XmlAccessorType(XmlAccessType.NONE) //Seul ceux spcifis
public class AtomCommande extends AtomConstruct{
	
	@XmlElement(name="content")
	private Commande content;
	
	/** Constructeurs */
	public AtomCommande(){}
	public AtomCommande(String baseURL, Commande com, boolean fullEntry){
		String selfURL = baseURL + "/ListeCommandeEmploye/"+ com.getEmploye().getId();
		
		//Setter les 3 obligatoires d'AtomConstruct
		setId(selfURL);
		setTitle("Comande Employe "+ com.getEmploye().getId());
		setUpdated(Calendar.getInstance().getTime().toString());
		
		if(fullEntry) {
			this.content = com;
			addLink(new AtomLink("edit",selfURL,"Atom+Xml"));
			addLink(new AtomLink("delete",selfURL+"/delete","Atom+Xml"));
		}
		else addLink(new AtomLink("alternate",selfURL,MediaType.APPLICATION_ATOM_XML));
	}
	
	public AtomCommande(Commande com){
		this.content = com;
	}
	
	//Accs  l'objet
	public Commande getContents(){
		return content;
	}	

}
