package transport;

import java.util.Calendar;

import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.annotation.XmlAccessType;

import modele.Employe;

@XmlRootElement(name="entry")
@XmlAccessorType(XmlAccessType.NONE) //Seul ceux spcifis
public class AtomEmploye extends AtomConstruct{
	
	@XmlElement(name="content")
	private Employe content;
	
	/** Constructeur */
	public AtomEmploye(){} //vide obligatoire
	public AtomEmploye(String baseURL,Employe emp ,boolean fullEntry){
		String selfURL = baseURL +"/"+ emp.getId();
		
		//Setter les 3 obligatoires d'AtomConstruct
		setId(selfURL);
		setTitle("Employe "+ emp.getId());
		setUpdated(Calendar.getInstance().getTime().toString());
		
		if(fullEntry) {
			this.content = emp;
			addLink(new AtomLink("detail",baseURL+"/ListeCommandeEmploye/"+emp.getId(),"Atom+Xml"));
			addLink(new AtomLink("edit",selfURL,"Atom+Xml"));
			addLink(new AtomLink("delete",selfURL+"/delete","Atom+Xml"));
		}
		else addLink(new AtomLink("alternate",selfURL,MediaType.APPLICATION_ATOM_XML));
	}
	
	public AtomEmploye(Employe e){
		String employeID = new Integer(e.getId()).toString();
		setTitle("Employe "+ employeID);
		setUpdated(Calendar.getInstance().getTime().toString());
		this.content = e;
	}
	
	//Accs  l'objet
	public Employe getContents(){
		return content;
	}	
}
