package transport;

import java.util.ArrayList;
import java.util.Calendar;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import modele.Employe;

@XmlRootElement(name="feed")
@XmlAccessorType(XmlAccessType.NONE) //Seul ceux spcifis
public class AtomEmployes extends AtomConstruct{
	
	@XmlElement(name="entry")
	private ArrayList<AtomEmploye> entries = new ArrayList<AtomEmploye>();
	
	public AtomEmployes(){}
	public AtomEmployes(String baseURL, ArrayList<Employe> listeEmploye){
		
		//Setter les 3 obligatoires d'AtomConstruct
		setId(baseURL);
		setTitle("Employes");
		setUpdated(Calendar.getInstance().getTime().toString());
		
		//AtomLink sur lui-mme
		addLink(new AtomLink("self",baseURL,"Atom+Xml"));
		
		//Dans le constructeur pour populer la liste d'objet Atom
		for(Employe e : listeEmploye){
			entries.add(new AtomEmploye(baseURL,e,true));
		}
	}//AtomEmployes(...)
	
	//Accs  l'objet
	public ArrayList<AtomEmploye> getEntries(){
		return entries;
	}	
}