package webServices;

import java.util.ArrayList;

import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriInfo;

import base.CapsuleDao;
import base.CommandeDao;
import base.EmployeDao;
import modele.Commande;
import modele.Employe;
import transport.AtomCapsules;
import transport.AtomCommande;
import transport.AtomCommandes;
import transport.AtomEmploye;
import transport.AtomEmployes;


@Path("/")
public class webServices {
	
	//ATOM : rcupre la liste des employs
	@GET
	@Path("ListeEmployes")
	@Produces(MediaType.APPLICATION_ATOM_XML)
	public AtomEmployes getListeEmployes(@Context UriInfo uriInfo) {
		System.out.println("getListeEmployesServeur ATOM"); //check
		String baseURI = uriInfo.getBaseUri().toString();
		return new AtomEmployes(baseURI+"Employes",EmployeDao.getListeEmployes());
	}//getListeEmployes
	
	
	//HTML : rcupre la liste des employs + liens HATEOAS par employ
	@GET
	@Path("ListeEmployes")
	@Produces(MediaType.TEXT_HTML)
	public String getListeEmployesHTML(@Context UriInfo uriInfo) {
		System.out.println("getListeEmployesServeur HTML"); //check
		String baseURI = uriInfo.getBaseUri().toString();
		
		ArrayList<Employe> alEmployes = EmployeDao.getListeEmployes();
		
		StringBuffer sb = new StringBuffer();
		sb.append("<HTML>");
		for (int i=0; i < alEmployes.size(); i++){
			sb.append(alEmployes.get(i).getNom()+
					  " <a href='"+baseURI+"ListeCommandeEmploye/"+ alEmployes.get(i).getId() +"'>detail</a>"
					+ " <a href='"+baseURI+"ListeCommandeEmploye/"+ alEmployes.get(i).getId() +"/edit'>edit</a>"
					+ " <a href='"+baseURI+"ListeCommandeEmploye/"+ alEmployes.get(i).getId() +"/delete'>delete</a><br />");
		}//for
		sb.append("</HTML>");
		
		return sb.toString();
	}//getListeEmployesHTML
	
	//ATOM : rcupre la liste des commandes d'un employ au format AtomCommandes
	@PUT
	@Path("ListeCommandeEmploye")
	@Consumes(MediaType.APPLICATION_ATOM_XML)
	@Produces(MediaType.APPLICATION_ATOM_XML)
	public AtomCommandes getListeCommandeEmploye(@Context UriInfo uriInfo, AtomEmploye atomEmploye) {
		String baseURI = uriInfo.getBaseUri().toString();
		System.out.println("getListeCommandeEmployeServer ATOM"); //check
		return new AtomCommandes(baseURI+"Commandes", CommandeDao.getListeCommandes(atomEmploye.getContents()));
	}
	
	
	//TEXT : rcupre la liste des commandes d'un employ au format String
	@PUT
	@Path("ListeCommandeEmploye")
	@Consumes(MediaType.TEXT_PLAIN)
	@Produces(MediaType.TEXT_PLAIN)
	public String getListeCommandeEmployeTxt(String idEmp) { //@Context UriInfo uriInfo : Pas obligatoire
		System.out.println("getListeCommandeEmployeServer TXT"); //check
		Employe emp = EmployeDao.getEmployes(idEmp); //on rcupre l'employ
		ArrayList<Commande> alCommandes = CommandeDao.getListeCommandes(emp); //on rcupre les commandes de l'employ
		
		StringBuffer sb = new StringBuffer();
		for (int i=0; i < alCommandes.size(); i++){
			sb.append(emp.getNom()+" "+emp.getPrenom()+" ").append(alCommandes.get(i).toStringTxt()).append("\n"); //retour  la ligne avec \n
		}
		return sb.toString();
	}
	
	
	//HTML : recupre la liste des commandes de l'employ (avec le id reu) au format HTML
	@GET
	@Path("ListeCommandeEmploye/{id}")
	@Produces(MediaType.TEXT_HTML)
	public String getListeCommandeEmployeHtml(@Context UriInfo uriInfo, @PathParam("id") String idEmp) {
		String baseURI = uriInfo.getBaseUri().toString();
		System.out.println("getListeCommandeEmployeServer HTML"); //check
		Employe emp = EmployeDao.getEmployes(idEmp); //on rcupre l'employ
		ArrayList<Commande> alCommandes = CommandeDao.getListeCommandes(emp); //on rcupre les commandes de l'employ
		
		StringBuffer sb = new StringBuffer();
		sb.append("<HTML>");
		if (alCommandes.isEmpty()){sb.append("Aucune commande <br />");
		}else{
			for (int i=0; i < alCommandes.size(); i++){
				sb.append(emp.getNom() +" "+ alCommandes.get(i).toStringTxt()+ "<br />");
			}//for
		}//else
		
		//URL vide si dpassement supprieur
		String lNext = "";
		if (emp.getId()+1 <= 20) {
			lNext = baseURI + "ListeCommandeEmploye/"+ Integer.toString(emp.getId()+1);
		}
		//URL vide si dpassement infrieur
		String lPrevious = "";
		if (emp.getId()-1 > 0) { 
			lPrevious = baseURI + "ListeCommandeEmploye/"+ Integer.toString(emp.getId()-1);
		}
		//Ajout des liens HATEOAS
		sb.append("<br /><a href='"+ lPrevious +"'>Previous</a> <a href='"+ lNext +"'>Next</a></HTML>");
		
		return sb.toString();
	}
	
}//webServices